#! /usr/bin/perl

$ENV{PATH} = "$ENV{PATH}:..";

use TTool;


#### TEST CONFIGURATIONS FOR THE SPECIFIC DOMAIN
sub bound1_test {
    my ($tstfile, $c, $e) = @_;
    my @classes = @$c;
    my @entity = @$e;
    my %bounds1;
    my %isentity;

    foreach $cl (@entity) {
        $isentity{$cl} = 1;
    }

    print "#####################################################\n";
    print "CHECKS FOR BOUND 1\n";
    print "#####################################################\n";

    foreach $cl (@classes) {
        $bounds1{$cl} = 1;
    }

    # exists the possibility to create all the instances
    DoExistsTest("EXISTS_1","$tstfile", %bounds1);

    foreach $cl (@classes) {
        if (defined($isentity{$cl})) {
            print "Skipping Class \"$cl\" since it is an Actor/Entity\n";
        }
        else {
            DoFulfillTest("FULFILL_${cl}_0_1", "$tstfile", "$cl", 0, %bounds1);
            DoFulfillTest("FULFILL_${cl}_1_1", "$tstfile", "$cl", 1, %bounds1);
        }
    }

    # for ($i = 1; $i <= 12; $i++) {
    for ($i = 1; $i <= 1; $i++) {
        DoGenericTest("ASSERTION_${i}_1", "$tstfile", "ASSE_${i}", %bounds1);
    }


    # for ($i = 1; $i <= 12; $i++) {
    for ($i = 1; $i <= 1; $i++) {
        DoGenericTest("POSSIBILITY_${i}_1", "$tstfile", "POSS_${i}", %bounds1);
    }

    print "#####################################################\n";
}

sub main {
    my @classes = ();
    my $tstfile = "";
    my @entity = ();

    if ($#ARGV == 0) {
        $tstfile = $ARGV[0];
    }
    else {
        print "WARNING: No file specified. Exiting.\n";
        exit(1);
    }

    SetNuSMVUseBMC();
    PrintConfig(\*STDOUT);

    CheckFname($tstfile);

    @entity = ExtractEntity($tstfile);

    @classes = ExtractClasses($tstfile);

    # tmp/EXISTS_1.bsmv.out
    bound1_test($tstfile,\@classes,\@entity);
}

main();

