/******************************************************************************

  FileName    [ft-int.h]

  PackageName [ft]

  Synopsis    [The internal interface of the ft package]

  Author      [Marco Pistore] 

  Copyright   [Copyright (C) 2003 by University of Trento.

  T-Tool is free software; you can redistribute it and/or modify it
  under the terms of the GNU Lesser General Public License as
  published by the Free Software Foundation; either version 2 of the
  License, or (at your option) any later version.

  T-Tool is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA.

  For more information on the T-Tool see <http://dit.unitn.it/~ft>
  or email to <ft@dit.unitn.it>. Please report bugs to <ft@dit.unitn.it>.]

******************************************************************************/

#ifndef FT_INT_H
#define FT_INT_H

struct _tDom {
  tElementSet elements;
  tPropSet globals;
};

struct _tElementSet {
  tElement element;
  tElementSet next;
};

struct _tElement {
  tElKind kind;
  tName name;
  tNameSet range;
  tType type;
  tMode mode;
  tName actorName;
  tElement actor;
  tName dependerName;
  tElement depender;
  tName dependeeName;
  tElement dependee;
  tAttrSet attrSet;
  tPropSet createSet;
  tPropSet invarSet;
  tPropSet fulfillSet;
};

struct _tNameSet {
  tName name;
  tNameSet next;
};

struct _tName {
  char * id;
};

struct _tSort {
  tSortKind kind;
  tName className;
  tElement class;
};

struct _tAttr {
  tName name;
  tSort sort;
  tAttrFacet attrFacet;
};

struct _tAttrFacet {
  int constantFacet;
};

struct _tAttrSet {
  tAttr attr;
  tAttrSet next;
};

struct _tProp {
  tCategory category;
  tEvent event;
  tOrigin origin;
  tExpr expr;
};

struct _tPropSet {
  tProp prop;
  tPropSet next;
};

struct _tExpr {
  tExprKind kind;
  tSort type;
  int num;
  tExpr e1;
  tExpr e2;
  tName name;
  tAtom atom;
  tName sort;
  tSort sortClass;
};

struct _tAtom {
  tAtomKind kind;
  tName name;
};

#endif /* FT_INT_H */
