%{
/******************************************************************************

  FileName    [ft-lex.c]

  PackageName [ft]

  Synopsis    [The lexer of the FT language]

  Author      [Marco Pistore] 

  Copyright   [Copyright (C) 2003 by University of Trento.

  T-Tool is free software; you can redistribute it and/or modify it
  under the terms of the GNU Lesser General Public License as
  published by the Free Software Foundation; either version 2 of the
  License, or (at your option) any later version.

  T-Tool is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA.

  For more information on the T-Tool see <http://dit.unitn.it/~ft>
  or email to <ft@dit.unitn.it>. Please report bugs to <ft@dit.unitn.it>.]

******************************************************************************/

#include "ft.h"
#include "ft-gra.h"

int ft_error(char *s);
%}

%option yylineno
%option noyywrap
%option nounput
%option prefix="ft_"
%option outfile="lex.yy.c"

%%

"ENTITY"                        { return ENTITY; }
"Entity"                        { return ENTITY; }
"entity"                        { return ENTITY; }

"ACTOR"                         { return ACTOR; }                
"Actor"                         { return ACTOR; }                
"actor"                         { return ACTOR; }                

"GOAL"                          { return GOAL; }                 
"Goal"                          { return GOAL; }                 
"goal"                          { return GOAL; }                 

"DEPENDENCY"                    { return DEPENDENCY; }
"Dependency"                    { return DEPENDENCY; }
"dependency"                    { return DEPENDENCY; }

"ATTRIBUTE"                     { return ATTRIBUTE; }            
"Attribute"                     { return ATTRIBUTE; }            
"attribute"                     { return ATTRIBUTE; }            

"CONSTANT"                      { return CONSTANT; }             
"Constant"                      { return CONSTANT; }             
"constant"                      { return CONSTANT; }             

"INTEGER"                       { return INTEGER; }          
"Integer"                       { return INTEGER; }          
"integer"                       { return INTEGER; }          

"BOOLEAN"                       { return BOOLEAN; }           
"Boolean"                       { return BOOLEAN; }           
"boolean"                       { return BOOLEAN; }           

"DEPENDER"                      { return DEPENDER; }             
"Depender"                      { return DEPENDER; }             
"depender"                      { return DEPENDER; }             

"DEPENDEE"                      { return DEPENDEE; }             
"Dependee"                      { return DEPENDEE; }             
"dependee"                      { return DEPENDEE; }             

"TYPE"                          { return TYPE; }                 
"Type"                          { return TYPE; }                 
"type"                          { return TYPE; }                 

"SOFTGOAL"                      { return SOFTGOAL; }             
"SoftGoal"                      { return SOFTGOAL; }             
"Softgoal"                      { return SOFTGOAL; }             
"softgoal"                      { return SOFTGOAL; }             

"TASK"                          { return TASK; }                 
"Task"                          { return TASK; }                 
"task"                          { return TASK; }                 

"RESOURCE"                      { return RESOURCE; } 
"Resource"                      { return RESOURCE; } 
"resource"                      { return RESOURCE; } 

"MODE"                          { return MODE; }              
"Mode"                          { return MODE; }              
"mode"                          { return MODE; }              

"ACHIEVE"                       { return ACHIEVE; }              
"Achieve"                       { return ACHIEVE; }              
"achieve"                       { return ACHIEVE; }              

"MAINTAIN"                      { return MAINTAIN; }             
"Maintain"                      { return MAINTAIN; }             
"maintain"                      { return MAINTAIN; }             

"ACHIEVE&MAINTAIN"              { return ACHIEVE_AND_MAINTAIN; }
"Achieve&Maintain"              { return ACHIEVE_AND_MAINTAIN; }
"achieve&maintain"              { return ACHIEVE_AND_MAINTAIN; }

"AVOID"                         { return AVOID; } 
"Avoid"                         { return AVOID; } 
"avoid"                         { return AVOID; } 

"GLOBAL"                        { return GLOBAL; }               
"Global"                        { return GLOBAL; }               
"global"                        { return GLOBAL; }               

"CREATION"                      { return CREATION; }             
"Creation"                      { return CREATION; }             
"creation"                      { return CREATION; }             

"INVAR"                         { return INVAR; }                
"Invar"                         { return INVAR; }                
"invar"                         { return INVAR; }                
"INVARIANT"                     { return INVAR; }                
"Invariant"                     { return INVAR; }                
"invariant"                     { return INVAR; }                

"FULFILLMENT"                   { return FULFILLMENT; }
"Fulfillment"                   { return FULFILLMENT; }
"fulfillment"                   { return FULFILLMENT; }

"CONSTRAINT"                    { return CONSTRAINT; }           
"Constraint"                    { return CONSTRAINT; }           
"constraint"                    { return CONSTRAINT; }           

"ASSERTION"                     { return ASSERTION; }            
"Assertion"                     { return ASSERTION; }            
"assertion"                     { return ASSERTION; }            

"POSSIBILITY"                   { return POSSIBILITY; }          
"Possibility"                   { return POSSIBILITY; }          
"possibility"                   { return POSSIBILITY; }          

"TRIGGER"                       { return TRIGGER; }              
"Trigger"                       { return TRIGGER; }              
"trigger"                       { return TRIGGER; }              

"CONDITION"                     { return CONDITION; }            
"Condition"                     { return CONDITION; }            
"condition"                     { return CONDITION; }            

"DEFINITION"                    { return DEFINITION; }           
"Definition"                    { return DEFINITION; }           
"definition"                    { return DEFINITION; }           

"FOR"                           { return FOR; }                  
"For"                           { return FOR; }                  
"for"                           { return FOR; }                  

"DOMAIN"                        { return DOMAIN; }              
"Domain"                        { return DOMAIN; }              
"domain"                        { return DOMAIN; }              

"TRUE"                          { return TRUE; }              
"True"                          { return TRUE; }              
"true"                          { return TRUE; }              

"FALSE"                         { return FALSE; }              
"False"                         { return FALSE; }              
"false"                         { return FALSE; }              

"FORALL"                        { return FORALL; }              
"Forall"                        { return FORALL; }              
"forall"                        { return FORALL; }              

"EXISTS"                        { return EXISTS; }              
"Exists"                        { return EXISTS; }              
"exists"                        { return EXISTS; }              

"SELF"                          { return SELF; }
"Self"                          { return SELF; }
"self"                          { return SELF; }

"FULFILLED"                     { return FULFILLED; }
"Fulfilled"                     { return FULFILLED; }
"fulfilled"                     { return FULFILLED; }

"JUSTFULFILLED"                 { return JUSTFULFILLED; }
"JustFulfilled"                 { return JUSTFULFILLED; }
"Justfulfilled"                 { return JUSTFULFILLED; }
"justfulfilled"                 { return JUSTFULFILLED; }

"JUSTCREATED"                   { return JUSTCREATED; }
"JustCreated"                   { return JUSTCREATED; }
"Justcreated"                   { return JUSTCREATED; }
"justcreated"                   { return JUSTCREATED; }

"X"                             return NEXT;
"Y"                             return PREV;
"F"                             return FINALLY;
"P"                             return PAST;
"G"                             return GLOBALLY;
"H"                             return PAST_GLOBALLY;
"U"                             return UNTIL;
"S"                             return SINCE;

"OR"           			return OR;
"AND"          			return AND;
"IMPLY"                         return IMPLIES;
"IFF"                           return IFF;
"NOT"                           return NOT;

--.*\n

[ \r\f\n\t]

[A-Za-z][A-Za-z0-9_]*           { ft_lval.name = mkName(ft_text); return NAME; }

"|"           			return OR;
"&"           			return AND;
"->"          			return IMPLIES;
"<->"         			return IFF;
"!"           			return NOT; 

"="           			return EQUAL;
"!="           			return NOTEQUAL;

[0-9]+        			{ ft_lval.num = atoi(ft_text); return NUMBER; }

":"                             { return ':'; }
"."                             { return '.'; }
"("                             { return '('; }
")"                             { return ')'; }

.                               { ft_error("illegal char"); }

%%

