/******************************************************************************

  FileName    [ft.h]

  PackageName [ft]

  Synopsis    [The interface of the ft package]

  Author      [Marco Pistore] 

  Copyright   [Copyright (C) 2003 by University of Trento.

  T-Tool is free software; you can redistribute it and/or modify it
  under the terms of the GNU Lesser General Public License as
  published by the Free Software Foundation; either version 2 of the
  License, or (at your option) any later version.

  T-Tool is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA.

  For more information on the T-Tool see <http://dit.unitn.it/~ft>
  or email to <ft@dit.unitn.it>. Please report bugs to <ft@dit.unitn.it>.]

******************************************************************************/

#ifndef FT_H
#define FT_H

#define ALLOC(type) (type *)(malloc(sizeof(type)))

typedef struct _tDom * tDom;
typedef struct _tElementSet * tElementSet;
typedef struct _tElement * tElement;
typedef enum { entityEl, actorEl, goalEl, depEl } tElKind;
typedef struct _tNameSet * tNameSet;
typedef struct _tName * tName;
typedef enum {intSort,boolSort,classSort} tSortKind;
typedef struct _tSort * tSort;
typedef struct _tAttr * tAttr;
typedef struct _tAttrFacet * tAttrFacet;
typedef struct _tAttrSet * tAttrSet;
typedef struct _tPropSet * tPropSet;
typedef struct _tProp * tProp;
typedef enum { noEvent, triggerEvent, conditionEvent, definitionEvent } tEvent;
typedef enum { noOrigin, dependerOrigin, dependeeOrigin, domainOrigin } tOrigin;
typedef enum { constraintCategory, assertionCategory, 
	       possibilityCategory } tCategory;
typedef enum { noMode, achieveMode, maintainMode, 
	       achieveMaintainMode, avoidMode } tMode;
typedef enum { noType, goalType, softGoalType, taskType, resourceType } tType;
typedef enum { 
  varExpr, dotVarExpr, andExpr, orExpr, impliesExpr, iffExpr, notExpr,
  nextExpr, prevExpr, untilExpr, sinceExpr, finallyExpr, pastExpr,
  globallyExpr, pastGloballyExpr, forallExpr, existsExpr, numberExpr,
  falseExpr, trueExpr, equalExpr, notEqualExpr, 
  fulfilledExpr, justFulfilledExpr, justCreatedExpr }  tExprKind;
typedef struct _tExpr * tExpr;
typedef enum { nameAtom, selfAtom, actorAtom, 
	       dependeeAtom, dependerAtom } tAtomKind;
typedef struct _tAtom * tAtom;

tNameSet mkNoNames();
tNameSet mkConsNameSet(tName, tNameSet);
tNameSet mkCupNameSet(tNameSet, tNameSet);
int isemptyNameSet(tNameSet);
tName firstName(tNameSet);
tNameSet nextNameSet(tNameSet);
int inNameSet(tName, tNameSet);

tName mkName(char *);
char * getNameString(tName);
int isequalName(tName,tName);

tDom mkEmptyDom();
tDom addElement(tDom,tElement);
tDom addGlobalProp(tDom,tProp);
tElementSet getDomElements(tDom);
tElementSet getDomEntities(tDom);
tElementSet getDomActors(tDom);
tElementSet getDomGoals(tDom);
tElementSet getDomDeps(tDom);
tPropSet getDomGlobalProps(tDom);

tElement getDomElementByName(tDom,tName);

int isemptyElementSet(tElementSet);
tElementSet nextElementSet(tElementSet);
tElement firstElement(tElementSet);

tElement mkClassEl(tName,tAttrSet);
tElement mkEntityEl(tName,tAttrSet,tPropSet,tPropSet);
tElement mkActorEl(tName,tAttrSet,tPropSet,tPropSet);
tElement mkGoalEl(tName,tType,tMode,tName,tAttrSet,tPropSet,tPropSet,tPropSet);
tElement mkDepEl(tName,tType,tMode,tName,tName,tAttrSet,tPropSet,tPropSet,tPropSet);

tElKind getElementKind(tElement);
tName getElementName(tElement);
tNameSet getElementRange(tElement);
tType getElementType(tElement);
tMode getElementMode(tElement);
tElement getElementActor(tElement);
tName getElementActorName(tElement);
tElement getElementDepender(tElement);
tName getElementDependerName(tElement);
tElement getElementDependee(tElement);
tName getElementDependeeName(tElement);
tAttrSet getElementAttrs(tElement);
void setElementRange(tElement, tNameSet);
void setElementAttrs(tElement, tAttrSet);
tPropSet getElementCreates(tElement);
tPropSet getElementInvars(tElement);
tPropSet getElementFulfills(tElement);
void setElementActor(tElement, tElement);
void setElementDepender(tElement, tElement);
void setElementDependee(tElement, tElement);

tPropSet mkNoProps();
tPropSet addProp(tProp,tPropSet);
tPropSet addProps(tPropSet,tPropSet);
int isemptyPropSet(tPropSet);
tPropSet nextPropSet(tPropSet);
tProp firstProp(tPropSet);

tProp mkProp(tCategory,tEvent,tOrigin,tExpr);
tCategory getPropCategory(tProp);
tEvent getPropEvent(tProp);
tOrigin getPropOrigin(tProp);
tExpr getPropExpr(tProp);

tAttrSet mkNoAttributes();
tAttrSet addAttribute(tAttr,tAttrSet);
int isemptyAttrSet(tAttrSet);
tAttrSet nextAttrSet(tAttrSet);
tAttr firstAttr(tAttrSet);

tAttr mkAttribute(tName,tSort,tAttrFacet);
tName getAttrName(tAttr);
tSort getAttrSort(tAttr);
tAttrFacet getAttrFacet(tAttr);

tSort mkClassNameSort(tName);
tSort mkClassSort(tElement);
tSort mkIntegerSort();
tSort mkBooleanSort();
tSortKind getSortKind(tSort);
tName getSortClassName(tSort);
tElement getSortClass(tSort);
void setSortClass(tSort, tElement);
int isequalSort(tSort,tSort);

tAttrFacet mkNoFacet();
tAttrFacet mkConstFacet();
int isConstFacet(tAttrFacet);

tType mkGoalType();
tType mkSoftGoalType();
tType mkTaskType();
tType mkResourceType();

tMode mkNoMode();
tMode mkAchieveMode();
tMode mkMaintainMode();
tMode mkAchieveMaintainMode();
tMode mkAvoidMode();

tCategory mkConstraintCategory();
tCategory mkAssertionCategory();
tCategory mkPossibilityCategory();

tEvent mkNoEvent();
tEvent mkTriggerEvent();
tEvent mkConditionEvent();
tEvent mkDefinitionEvent();

tOrigin mkNoOrigin();
tOrigin mkDependerOrigin();
tOrigin mkDependeeOrigin();
tOrigin mkDomainOrigin();

tAtom mkNameAtom(tName);
tAtom mkSelfAtom();
tAtom mkActorAtom();
tAtom mkDependeeAtom();
tAtom mkDependerAtom();
tAtomKind getAtomKind(tAtom);
tName getAtomName(tAtom);

tExpr mkVar(tAtom);
tExpr mkDotVar(tExpr,tAtom);
tExpr mkAnd(tExpr,tExpr);
tExpr mkOr(tExpr,tExpr);
tExpr mkImplies(tExpr,tExpr);
tExpr mkIff(tExpr,tExpr);
tExpr mkNot(tExpr);
tExpr mkNext(tExpr);
tExpr mkPrev(tExpr);
tExpr mkUntil(tExpr,tExpr);
tExpr mkSince(tExpr,tExpr);
tExpr mkFinally(tExpr);
tExpr mkPast(tExpr);
tExpr mkGlobally(tExpr);
tExpr mkPastGlobally(tExpr);
tExpr mkForall(tName,tName,tExpr);
tExpr mkExists(tName,tName,tExpr);
tExpr mkNumber(int);
tExpr mkFalse();
tExpr mkTrue();
tExpr mkEqual(tExpr,tExpr);
tExpr mkNotEqual(tExpr,tExpr);
tExpr mkFulfilled(tExpr);
tExpr mkJustFulfilled(tExpr);
tExpr mkJustCreated(tExpr);
tExprKind getExprKind(tExpr);
tSort getExprType(tExpr);
tAtom getExprVar(tExpr);
tExpr getExprDotPrefix(tExpr);
tAtom getExprDotSuffix(tExpr);
tExpr getExprFirstOp(tExpr);
tExpr getExprSecondOp(tExpr);
tExpr getExprOp(tExpr);
tName getExprQuantVar(tExpr);
tName getExprQuantClass(tExpr);
tSort getExprQuantType(tExpr);
tExpr getExprQuantBody(tExpr);
int getExprNumber(tExpr);
void setExprType(tExpr,tSort);
void setExprQuantType(tExpr,tSort);
tNameSet getExprFv(tExpr);

void printFT(FILE *, tDom);
void printIL(FILE *, tDom);
void printBIL(FILE *, tDom);
void printSMV(FILE *, tDom);

tDom parseFT();
void typeCheckFT(tDom);

tDom parseIL();
void typeCheckIL(tDom);

typedef struct _tBounds * tBounds;

tBounds singleBounds(tDom);
tBounds doubleBounds(tDom);
tBounds parseBounds(FILE *, tDom);

tDom instantiateDomain(tDom, tBounds);

tDom FT2IL(tDom);
tDom IL2SMV(tDom);

#endif
