/******************************************************************************

  FileName    [ft2il.c]

  PackageName [ft]

  Synopsis    [The Formal Tropos to Intermediate Language translator]

  Author      [Marco Pistore] 

  Copyright   [Copyright (C) 2003 by University of Trento.

  T-Tool is free software; you can redistribute it and/or modify it
  under the terms of the GNU Lesser General Public License as
  published by the Free Software Foundation; either version 2 of the
  License, or (at your option) any later version.

  T-Tool is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA.

  For more information on the T-Tool see <http://dit.unitn.it/~ft>
  or email to <ft@dit.unitn.it>. Please report bugs to <ft@dit.unitn.it>.]

******************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include "ft.h"

void usage() 
{
  fprintf(stderr, "Usage: ft2il [ <input> ]\n");
  fprintf(stderr, "       <input>    : file with FT specification (DEFAUL: stdin)\n");
}


int main(int argc, char *argv[])
{
  char * ftf_name = NULL;

  tDom domFT, domIL;
  FILE * ftf;

  argc--; argv++;

  while (argc > 0) {
    if (strcmp(*argv,"-h") == 0 || strcmp(*argv,"-help") == 0) {
      usage();
      return 1;
    }

    if (argc > 1) {
      usage();
      return 1;
    }
    ftf_name = *argv;
    argc--; argv++;
  }

  if (ftf_name == NULL) {
    domFT = parseFT(stdin);
  } else {
    ftf = fopen(ftf_name, "r");
    assert(ftf);
    domFT = parseFT(ftf);
    fclose(ftf);
  }

  typeCheckFT(domFT);

  domIL = FT2IL(domFT);
  printIL(stdout, domIL);

  return 0;
}
