%{
/******************************************************************************

  FileName    [il-lex.c]

  PackageName [ft]

  Synopsis    [The lexer of the IL language]

  Author      [Marco Pistore] 

  Copyright   [Copyright (C) 2003 by University of Trento.

  T-Tool is free software; you can redistribute it and/or modify it
  under the terms of the GNU Lesser General Public License as
  published by the Free Software Foundation; either version 2 of the
  License, or (at your option) any later version.

  T-Tool is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA.

  For more information on the T-Tool see <http://dit.unitn.it/~ft>
  or email to <ft@dit.unitn.it>. Please report bugs to <ft@dit.unitn.it>.]

******************************************************************************/

#include "ft.h"
#include "il-gra.h"

int il_error(char *s);
%}

%option yylineno
%option noyywrap
%option nounput
%option prefix="il_"
%option outfile="lex.yy.c"

%%

"CLASS"                         { return CLASS; }
"Class"                         { return CLASS; }
"class"                         { return CLASS; }

"INTEGER"                       { return INTEGER; }          
"Integer"                       { return INTEGER; }          
"integer"                       { return INTEGER; }          

"BOOLEAN"                       { return BOOLEAN; }           
"Boolean"                       { return BOOLEAN; }           
"boolean"                       { return BOOLEAN; }           

"CONSTRAINT"                    { return CONSTRAINT; }           
"Constraint"                    { return CONSTRAINT; }           
"constraint"                    { return CONSTRAINT; }           

"ASSERTION"                     { return ASSERTION; }            
"Assertion"                     { return ASSERTION; }            
"assertion"                     { return ASSERTION; }            

"POSSIBILITY"                   { return POSSIBILITY; }          
"Possibility"                   { return POSSIBILITY; }          
"possibility"                   { return POSSIBILITY; }          

"TRUE"                          { return TRUE; }              
"True"                          { return TRUE; }              
"true"                          { return TRUE; }              

"FALSE"                         { return FALSE; }              
"False"                         { return FALSE; }              
"false"                         { return FALSE; }              

"FORALL"                        { return FORALL; }              
"Forall"                        { return FORALL; }              
"forall"                        { return FORALL; }              

"EXISTS"                        { return EXISTS; }              
"Exists"                        { return EXISTS; }              
"exists"                        { return EXISTS; }              

"X"                             return NEXT;
"Y"                             return PREV;
"F"                             return FINALLY;
"P"                             return PAST;
"G"                             return GLOBALLY;
"H"                             return PAST_GLOBALLY;
"U"                             return UNTIL;
"S"                             return SINCE;

"OR"           			return OR;
"AND"          			return AND;
"IMPLY"                         return IMPLIES;
"IFF"                           return IFF;
"NOT"                           return NOT;

--.*\n

[ \r\f\n\t]

[A-Za-z_][A-Za-z0-9_]*           { il_lval.name = mkName(il_text); return NAME; }

"|"           			return OR;
"&"           			return AND;
"->"          			return IMPLIES;
"<->"         			return IFF;
"!"           			return NOT; 

"="           			return EQUAL;
"!="           			return NOTEQUAL;

[0-9]+        			{ il_lval.num = atoi(il_text); return NUMBER; }

":"                             { return ':'; }
"."                             { return '.'; }
"("                             { return '('; }
")"                             { return ')'; }

.                               { il_error("illegal char"); }

%%

