/******************************************************************************

  FileName    [il2smv.c]

  PackageName [ft]

  Synopsis    [The Intermediate Language to SMV Language translator]

  Author      [Marco Pistore] 

  Copyright   [Copyright (C) 2003 by University of Trento.

  T-Tool is free software; you can redistribute it and/or modify it
  under the terms of the GNU Lesser General Public License as
  published by the Free Software Foundation; either version 2 of the
  License, or (at your option) any later version.

  T-Tool is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA.

  For more information on the T-Tool see <http://dit.unitn.it/~ft>
  or email to <ft@dit.unitn.it>. Please report bugs to <ft@dit.unitn.it>.]

******************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include "ft.h"

void usage() 
{
  fprintf(stderr, "Usage: il2smv [ -1 | -2 | -bf <file> ] [ <input> ]\n");
  fprintf(stderr, "where: -1         : upper bounds are set to 1 (DEFAULT)\n");
  fprintf(stderr, "       -2         : upper bounds are set to 2\n");
  fprintf(stderr, "       -bf <file> : upper bounds are set according to <file>\n");
  fprintf(stderr, "       <input>    : file with IL specification (DEFAUL: stdin)\n");
}


int main(int argc, char *argv[])
{
  char * bf_name = (char *)1;
  char * ilf_name = NULL;

  tDom domIL, domSMV;
  tBounds bs;
  FILE * bf, * ilf;

  argc--; argv++;

  while (argc > 0) {
    if (strcmp(*argv,"-h") == 0 || strcmp(*argv,"-help") == 0) {
      usage();
      return 1;
    }

    if (strcmp(*argv,"-1") == 0) {
      bf_name = (char *)1;
      argc--; argv++;
    } else if (strcmp(*argv,"-2") == 0) {
      bf_name = (char *)2;
      argc--; argv++;
    } else if (strcmp(*argv,"-bf") == 0) {
      if (argc == 1) {
	usage();
	return 1;
      }
      argc--; argv++;
      bf_name = *argv;
      argc--; argv++;
    } else {
      if (argc > 1) {
	usage();
	return 1;
      }
      ilf_name = *argv;
      argc--; argv++;
    }
  }

  if (ilf_name == NULL) {
    domIL = parseIL(stdin);
  } else {
    ilf = fopen(ilf_name, "r");
    assert(ilf);
    domIL = parseIL(ilf);
    fclose(ilf);
  }

  typeCheckIL(domIL);

  if (bf_name == (char*)1) {
    bs = singleBounds(domIL); 
  } else if (bf_name == (char*)2) {
    bs = doubleBounds(domIL); 
  } else {
    bf = fopen(bf_name,"r");
    assert(bf);
    bs = parseBounds(bf, domIL);
    fclose(bf);
  }

  domIL = instantiateDomain(domIL, bs);

  domSMV = IL2SMV(domIL);

  printSMV(stdout, domSMV);

  return 0;
}
