/* S_boxes.c: modulo che trasforma, per ogni iterazione, le S-boxes in
	          formule.                                                  */

#include <stdio.h>
#include <stdlib.h>
#include "S_boxes.h"
#include "scrivi.h"
#include "iterades.h"
#include "strutt.h"
#include "minimiz.h"
#include "input.h"

extern variabile variabili[];
extern lista_and* and;
extern lista_and* ultimo_and;
variabile var[32];
FILE* f;
int indice;
lista_and* inizio_S_box;


void prepara_variabile_bis(char,int,int,int,int,int);
void inserisci_in_lista(char*,int,int,int);

/* Funzione che trasforma le S-box in formule nel seguente modo:
   per ogni output di ciascuna S-box e' stato costruito un file che contiene, in un 
   formato ad hoc, la semplificazione fornita da Espresso. Tale file viene letto e,
   per ciascun mintermine viene costruita una formula AND, mentre per il file complessivo,
   viene costruita una formula OR che colletga tutti i mintermini.                         */
void S_boxes(int i, int k)
{   int y,j;
	char* nome_file;
	indice=1;
	for(y=1;y<9;y++)
    {   inizio_S_box=ultimo_and;
	    switch(y)
	    { case 1: for(j=1;j<5;j++)
	                switch(j)
					{ case 1: nome_file=S1;
				              inserisci_in_lista(nome_file,i,k,1);
				              break;
			          case 2: nome_file=S2;
				              inserisci_in_lista(nome_file,i,k,2);
			                  break;
			          case 3: nome_file=S3;
				              inserisci_in_lista(nome_file,i,k,3);
				              break;
			          case 4: nome_file=S4;
				              inserisci_in_lista(nome_file,i,k,4);
			                  break;
					}
                  break;
	      case 2: for(j=1;j<5;j++)
	                switch(j)
					{ case 1: nome_file=S5;
				              inserisci_in_lista(nome_file,i,k,5);
			                  break;
			          case 2: nome_file=S6;
				              inserisci_in_lista(nome_file,i,k,6);
			                  break;
			          case 3: nome_file=S7;
				              inserisci_in_lista(nome_file,i,k,7);
			                  break;
			          case 4: nome_file=S8;
				              inserisci_in_lista(nome_file,i,k,8);
			                  break;
					}
	              break;
	      case 3: for(j=1;j<5;j++)
	                switch(j)
					{ case 1: nome_file=S9;
				              inserisci_in_lista(nome_file,i,k,9);
			                  break;
			          case 2: nome_file=S10;
				              inserisci_in_lista(nome_file,i,k,10);
			                  break;
			          case 3: nome_file=S11;
				              inserisci_in_lista(nome_file,i,k,11);
			                  break;
			          case 4: nome_file=S12;
			 	              inserisci_in_lista(nome_file,i,k,12);
			                  break;
	                }
	              break;
	      case 4: for(j=1;j<5;j++)
	                switch(j)
					{ case 1: nome_file=S13;
				              inserisci_in_lista(nome_file,i,k,13);
			                  break;
			          case 2: nome_file=S14;
				              inserisci_in_lista(nome_file,i,k,14);
			                  break;
			          case 3: nome_file=S15;
				              inserisci_in_lista(nome_file,i,k,15);
			                  break;
			          case 4: nome_file=S16;
				              inserisci_in_lista(nome_file,i,k,16);
			                  break;
	                }
	              break;
	      case 5: for(j=1;j<5;j++)
	                switch(j)
					{ case 1: nome_file=S17;
				              inserisci_in_lista(nome_file,i,k,17);
			                  break;
			          case 2: nome_file=S18;
				              inserisci_in_lista(nome_file,i,k,18);
			                  break;
			          case 3: nome_file=S19;
				              inserisci_in_lista(nome_file,i,k,19);
			                  break;
			          case 4: nome_file=S20;
				              inserisci_in_lista(nome_file,i,k,20);
			                  break;
	                }
	              break;
	      case 6: for(j=1;j<5;j++)
	                switch(j)
					{ case 1: nome_file=S21;
				              inserisci_in_lista(nome_file,i,k,21);
			                  break;
			          case 2: nome_file=S22;
				              inserisci_in_lista(nome_file,i,k,22);
			                  break;
			          case 3: nome_file=S23;
				              inserisci_in_lista(nome_file,i,k,23);
			                  break;
			          case 4: nome_file=S24;
				              inserisci_in_lista(nome_file,i,k,24);
			                  break;
	                }
	              break;
	      case 7: for(j=1;j<5;j++)
	                switch(j)
					{ case 1: nome_file=S25;
				              inserisci_in_lista(nome_file,i,k,25);
			                  break;
			          case 2: nome_file=S26;
				              inserisci_in_lista(nome_file,i,k,26);
			                  break;
			          case 3: nome_file=S27;
				              inserisci_in_lista(nome_file,i,k,27);
				              break;
			          case 4: nome_file=S28;
				              inserisci_in_lista(nome_file,i,k,28);
				              break;
	                }
	              break;
	      case 8: for(j=1;j<5;j++)
	                switch(j)
					{ case 1: nome_file=S29;
				              inserisci_in_lista(nome_file,i,k,29);
			                  break;
			          case 2: nome_file=S30;
				              inserisci_in_lista(nome_file,i,k,30);
			                  break;
			          case 3: nome_file=S31;
				              inserisci_in_lista(nome_file,i,k,31);
			                  break;
			          case 4: nome_file=S32;
				              inserisci_in_lista(nome_file,i,k,32);
			                  break;
	                }
	              break;
	    }
	    if(inizio_S_box!=0)
	       inizio_S_box->next=elimina_duplicati(inizio_S_box->next);
	    else and=elimina_duplicati(and);
        }
}

/* Funzione che inserisce nel vettore var tutte le informazioni
   necessarie per costruire le formule                                 */
void prepara_variabile_bis(char nome,int h,int i,int k,int neg,int num)
/* nome=nome variabile; h=posizione bit; i=numero iterazione;
   k=numero blocco; neg=switch che indica se la variabile  negata;
   val=attribuisce,eventualmente un valore alla variabile;
   num=posizione del vettore variabili in cui devono essere inserite le
   precedenti informazioni                                              */
{	if(nome==0)
	{   var[num].nome=0;
		return;
        }
	var[num].nome=nome;
	var[num].posizione_bit=h;
	var[num].numero_iterazione=i;
	var[num].numero_blocco=k;
	var[num].negata=neg;
}

/* Funzione che costruisce materialmente le formule e le inserisce nelle liste */
void inserisci_in_lista(char* nome_file, int i, int k, int indice_S)
{	if((f=fopen(nome_file,"r"))==NULL)
	{  printf("Error: file %s doesn't exist",nome_file);
	   exit(1);
	}
	int h;
	int z=0;
	int num;
	prepara_variabile_bis('S',indice_S,i,k,0,z);
    z=1;
    while(feof(f)==0)
	{  h=0;
	   fscanf(f,"%d",&num);
	   prepara_variabile('M',indice,i,k,0,h);
	   h=1;
       while(num!=0)
	   {  if(num>0)
	         prepara_variabile('X',num,i,k,0,h);
	      else
	         prepara_variabile('X',-num,i,k,1,h);
	      h=h+1;
	      fscanf(f,"%d",&num);
	   }
	   prepara_variabile(0,0,0,0,0,h);
	   scrivi_in_lista(variabili,3);
	   prepara_variabile_bis('M',indice,i,k,0,z);
	   indice=indice+1;
	   z=z+1;
	}
	prepara_variabile_bis(0,0,0,0,0,z);
	scrivi_in_lista(var,2);
	fclose(f);
}
        
