/* chiave.c: Modulo che fornisce le 48 variabili, rappresentanti la chiave,
             necessarie per ciascuna iterazione */

#include "chiave.h"
#include <stdio.h>
#include "leggi_pp.h"
#include "leggi_sp.h"
#include "leggi_sh.h"

int chiave[]={1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,
	      23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,
	      43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,
	      63,64}; /* Vettore rappresentante i 64 bits della chiave */

int chiave_permutata[56]; /* contiene i 56 bits significativi permutati */

/* I vettori successivi permettono di implementare l'algoritmo di
   manipolazione della chiave */
static int c[28]; /* Svolge le funzioni dell'omonimo vettore c di DES   */
static int d[28]; /* Svolge le funzioni dell'omonimo vettore d di DES   */
int temp1[28];
int temp2[28];
int chiave_shiftata[56]; /* Contiene i 56 bits della chiave che hanno
			    subito la prima permutazione e la/le
			    operazione/i di shift                       */ 


/* Il vettore successivo indica il numero di shift da effettuare per
   ciascuna iterazione */
int numero_shift[16];

/* I seguenti due vettori indicano le due permutazioni che devono essere
   eseguite sulla chiave */
int prima_permutazione[56];
int seconda_permutazione[48];


/* Effettua la permutazione iniziale sulla chiave (tale permutazione riduce
   altres i bits a 56), e spezza tale permutazione in due parti */
void permuta_chiave()
{	int i, /* Variabile usata come indice nei cicli */
        h; /* Variabile di appoggio                 */
	for(i=0;i<56;i++)
	{	h = prima_permutazione[i];
		chiave_permutata[i] = chiave[h-1];
	}
	for(i=0;i<28;i++)
	    c[i] = chiave_permutata[i];
        for(i=28;i<56;i++)
	    d[i-28] = chiave_permutata[i];

}

/* Effettua l'operazione di shift.
   Tale operazione viene cos effettuata:
      1) Per ciascuno dei 28 bits di c e d, calcola la posizione (k)
	 che ciascun bit andr ad occupare dopo lo shift. Se tale
	 valore  negativo, allora per calcolare la posizione si
	 dovr sommare algebricamente tale valore a 27 (in C++
	 i vettori partono da zero);
      2) Effettua lo shift;
      3) Unisci le due parti in un unico vettore;
      4) Aggiorna c e d.                                             */
void effettua_shift(int n) /* n rappresenta l'iterazione per cui serve
                              la chiave                              */
{   int i, /* Variabile usata come indice nei cicli */
	k;
    for(i=0;i<28;i++)
	{   k=(i+1-numero_shift[n-1]);
	    if(k<=0)
	    {   temp1[27+k] = c[i];
                temp2[27+k] = d[i];   }
	    else { temp1[k-1] = c[i];
		   temp2[k-1] = d[i]; }
        }
	for(i=0;i<28;i++)
	{	chiave_shiftata[i] = temp1[i];
		chiave_shiftata[28+i] = temp2[i];
		c[i] = temp1[i];
		d[i] = temp2[i];
	}
}

/* Fornisce, in base all'iterazione, la chiave necessaria a DES */
void fornisci_chiave(int h, int n, int* chiave_ridotta)
/* n rappresenta l'iterazione per cui si deve calcolare la chiave,
   h rappresenta il blocco di plaintext trattato,
   chiave_ridotta contiene il valore ritornato della chiave     */
{	int i,sp;
	if((n==1)&&(h==1))
	{  leggi_prima_permutazione();
	   leggi_seconda_permutazione();
	   leggi_shift();
        }
	if(n==1)
           permuta_chiave(); 
	effettua_shift(n);
        for(i=0;i<48;i++)
	{	sp = seconda_permutazione[i];
		chiave_ridotta[i] = chiave_shiftata[sp-1];
	}
}








  
