/* confron.c : modulo che esegue alcuni aggiustamenti sulla lista delle 
               identita'                                                */

#include "strutt.h"
#include "confron.h"
#include "modif_id.h"
#include "comune.h"
#include <stdio.h>
#include <stdlib.h>

extern lista_identita* identity;

int sostituisci(definizione*,definizione*);

/* Funzione che effettua la propagazione delle identita'
   nella lista delle identita'                           */
void propaga_in_listaID()
{	lista_identita* attuale;
	lista_identita* scorri;
	lista_identita* precedente;
	formula* sinistra;
	formula* destra;
	int cambiato,cambiato_temp;
	cambiato=1;
	/* controlla ciascun elemento della lista con tutti gli altri elementi finche'
	   cambia qualcosa   */
	while(cambiato)
    {  cambiato=0;
	   attuale=identity;
	   while(attuale!=0)
	   {  scorri=identity;
	      precedente=identity;
	      while(scorri!=0)
		  { /* se i due elementi coincidono si passa all'elemento successivo da confrontare */
	        if(scorri==attuale)
			{  if(scorri!=precedente)
			      precedente=precedente->next;
			   scorri=scorri->next;
		       continue;
			}
		    /* esecuzione del controllo */
		    cambiato_temp=sostituisci(attuale->identita,scorri->identita);
			if(cambiato==0)
			   cambiato=cambiato_temp;
		    normalizza(scorri->identita);
		    sinistra=scorri->identita->parte_sinistra;
            destra=scorri->identita->parte_destra;
	        if(sinistra->tipo_elemento==TRUE)
	          if(destra->tipo_elemento==FALSE)
			  {  
				 printf("Error: an absurd have been obtained.\n");
			     printf("       With the values specified the system isn't satisfiable!\n");
		         exit(1);
			  }
	          else  if(destra->tipo_elemento==TRUE)
					{   if(scorri==precedente)
						{  identity=scorri->next;
	                       precedente=scorri->next; }
		                else precedente->next=scorri->next;
		                scorri=scorri->next;
		                continue;
					}
	        if(scorri!=precedente)
	           precedente=precedente->next;
	        scorri=scorri->next;
		  }
	      attuale=attuale->next;
		}
	}
} 

int sostituisci(definizione* def, definizione* def1)
/* def = elemento di controllo    def1= elemento controllato */
{	formula* destra1;
	formula* destra;
    formula* sinistra1;
	formula* form;
	int camb=0;
	destra=def->parte_destra;
	destra1=def1->parte_destra;
	sinistra1=def1->parte_sinistra;
	form=def->parte_sinistra;
	/* controlla la parte sinistra di def con la parte destra di def1 */
	if variabili_uguali(destra1,form)
	{ camb=1;
	  if(destra1->var->negata==form->var->negata)
	     if(destra->tipo_elemento!=VARIABILE)
		    destra1->tipo_elemento=destra->tipo_elemento;
		 else
		    copia(destra1,destra);
      else
	     if(destra->tipo_elemento==FALSE)
		    destra1->tipo_elemento=TRUE;
		 else   if(destra->tipo_elemento==TRUE)
				   destra1->tipo_elemento=FALSE;
		        else
				{ copia_var(destra1,destra);
				  if(destra->var->negata==0)
			         destra1->var->negata=1;
		          else destra1->var->negata=0;
				}
	}
	/* controlla la parte sinistra di def con la parte sinistra di def1 */
	if variabili_uguali(sinistra1,form)
	{ camb=1;
      if(sinistra1->var->negata==form->var->negata)
	     if(destra->tipo_elemento!=VARIABILE)
		    sinistra1->tipo_elemento=destra->tipo_elemento;
		 else
		    copia(sinistra1,destra);
	  else
	     if(destra->tipo_elemento==FALSE)
		    sinistra1->tipo_elemento=TRUE;
		  else   if(destra->tipo_elemento==TRUE)
				    sinistra1->tipo_elemento=FALSE;
		         else
				{ copia_var(sinistra1,destra);
				  if(destra->var->negata==0)
			         sinistra1->var->negata=1;
		          else sinistra1->var->negata=0;
				}
	}
	return camb;
}