/* creafile.c: Questo programma prende le S-boxes, le trasforma in binario
	           e le memorizza su files in formato tale da poter essere
	           lette da Espresso */

#include <stdio.h>
#include "leggi_Sb.h"

/* Vettori che rappresentano le S-boxes di DES  */
int S1[64];
int S2[64];
int S3[64];
int S4[64];
int S5[64];
int S6[64];
int S7[64];
int S8[64];

/***************** Prototipi delle funzioni utilizzate *****************/
/*     stampa(numero matrice, posizione dell'elemento nella matrice,  
              valori delle variabili di input per Espresso,           
              valori delle variabili di output per Espresso)           */
void stampa(int,int,int*,int*);

/* conv(matrice da trasformare in file, posizione dell'elemento nella
        matrice, numero matrice)                                       */                
void conv(int*,int,int);
/***********************************************************************/

/* Esegue le operazioni suddette per ciascuna delle 8 S-boxes */  
void main()
{	int i,j; /* Variabili usate come indici per i cicli */
	leggi_S_box(1);
	leggi_S_box(2);
	leggi_S_box(3);
	leggi_S_box(4);
	leggi_S_box(5);
	leggi_S_box(6);
	leggi_S_box(7);
	leggi_S_box(8);
	for(i=0;i<8;i++)
	{	for(j=0;j<64;j++)
		{   switch(i)
			{  case 0: conv(S1,j,i+1); break;
			   case 1: conv(S2,j,i+1); break;
			   case 2: conv(S3,j,i+1); break;
			   case 3: conv(S4,j,i+1); break;
			   case 4: conv(S5,j,i+1); break;
			   case 5: conv(S6,j,i+1); break;
			   case 6: conv(S7,j,i+1); break;
			   case 7: conv(S8,j,i+1); break;
			}
		}
	}
}

/* Data la S-box S, trasforma ciascun elemento della matrice in binario
   e poi lo invia alla funzione stampa per essere scritto su un file    */
void conv(int* S,int in,int matrice)
{      int resto, /* Contiene il resto della divisione per 2 del numero
                     da convertire                                     */
	    i,     /* Variabile usata come indice per i cicli           */
	    diviso=in; /* Contiene il valore della divisione intera per
			  2, viene inizializzato con il numero indicante
			  la posizione nella S-box. Dopo tale conversione,
			  verr inizializzato con il valore del numero
			  contenuto in posizione in-iesima nella S-box. */                          
	int input[6]; /* Contiene, di volta in volta, il valore di input
			 (in binario), relativo ad un particolare
			 elemento, da registrare sul file               */
	int output[6]; /* Contiene, di volta in volta, il valore di
	                  output (in binario), relativo ad un particolare
		          elemento, da registrare sul file              */

	/* Conversione dei bits di ingresso alla S-box secondo la
	   tradizionale conversione decimale-binario              */  
	for(i=0;i<6;i++)
	{	resto = diviso%2;
		diviso = diviso/2;
		input[5-i] = resto;
	}
	diviso = S[in];
        /* Conversione dei bits in uscita dalla S-box */
	for(i=0;i<4;i++)
	{	resto = diviso%2;
		diviso = diviso/2;
		output[3-i] = resto;
	}
	/* Scrivi gli elementi input e output della S-boxes
	   sul file appropriato                              */ 
	stampa(matrice,in,input,output);
}

/* Crea per ciascuna S-boxes il file in formato leggibile da Espresso */ 
void stampa(int matrice, int iterazione, int* input, int* output)
{       static FILE* s1;
	static FILE* s2;
	static FILE* s3;
	static FILE* s4;
	static FILE* s5;
	static FILE* s6;
	static FILE* s7;
	static FILE* s8;
	int i; /* Variabile usata come indice nei cicli   */
	switch(matrice){
	case 1: /* Verifica l'esistenza del file  */
		if(iterazione==0)
		{  /* Se il file non esiste lo crea e lo inizializza */
		   if((s1=fopen("matS1","wb")==NULL)
		   { printf("Errore: impossibile creare il file matS1\n");
			     exit(1);
                   } 
		   fprintf(s1,"# Prima S-box\n");
		   fprintf(s1,".i 6\n");
		   fprintf(s1,".o 4\n");
		   fprintf(s1,".ilb x1 x6 x2 x3 x4 x5\n");
		   fprintf(s1,".ob s1 s2 s3 s4\n");
		}
                /* Procede alla scrittura del file  */
		for(i=0;i<6;i++)
		   fprintf(s1,"%i",input[i]);
		fprintf(s1," ");
		for(i=0;i<4;i++)
		   fprintf(s1,"%i",output[i]);
		fprintf(s1,"\n");
		if(iterazione==63)
		   fclose(s1);
                break;
	/* Quanto segue funziona, per le altre S-boxes, in
	   maniera analoga al caso precedente               */
	case 2: 
		if(iterazione==0)
		{  if((s2=fopen("matS2","wb")==NULL)
		   { printf("Errore: impossibile creare il file matS2\n");
		     exit(1);
                   }
		   fprintf(s1,"# Seconda S-box\n");
		   fprintf(s2,".i 6\n");
		   fprintf(s2,".o 4\n");
		   fprintf(s2,".ilb x7 x12 x8 x9 x10 x11\n");
		   fprintf(s2,".ob s5 s6 s7 s8\n");
		}
		for(i=0;i<6;i++)
		   fprintf(s2,"%i",input[i]);
		fprintf(s2," ");
		for(i=0;i<4;i++)
		   fprintf(s2,"%i",output[i]);
		fprintf(s2,"\n");
		if(iterazione==63)
		   fclose(s2);
                break;
	case 3: 
		if(iterazione==0)
		{  if((s3=fopen("matS3","wb")==NULL)
		   { printf("Errore: impossibile creare il file matS3\n");
		     exit(1);
                   }
 		   fprintf(s1,"# Terza S-box\n");
		   fprintf(s3,".i 6\n");
		   fprintf(s3,".o 4\n");
		   fprintf(s3,".ilb x13 x18 x14 x15 x16 x17\n");
		   fprintf(s3,".ob s9 s10 s11 s12\n");
		}
		for(i=0;i<6;i++)
		   fprintf(s3,"%i",input[i]);
		fprintf(s3," ");
		for(i=0;i<4;i++)
		   fprintf(s3,"%i",output[i]);
		fprintf(s3,"\n");
		if(iterazione==63)
		   fclose(s3);
		break;
	case 4: if(iterazione==0)
		{  if((s4=fopen("matS4","wb")==NULL)
		   { printf("Errore: impossibile creare il file matS4\n");
		     exit(1);
                   }
	           fprintf(s1,"# Quarta S-box\n");
		   fprintf(s4,".i 6\n");
	           fprintf(s4,".o 4\n");
		   fprintf(s4,".ilb x19 x24 x20 x21 x22 x23\n");
	           fprintf(s4,".ob s13 s14 s15 s16\n");
		}
		for(i=0;i<6;i++)
   	            fprintf(s4,"%i",input[i]);
		fprintf(s4," ");
		for(i=0;i<4;i++)
		   fprintf(s4,"%i",output[i]);
		fprintf(s4,"\n");
		if(iterazione==63)
		   fclose(s4);
		break;
	case 5: 
		if(iterazione==0)
		{  if((s5=fopen("matS5","wb")==NULL)
		   { printf("Errore: impossibile creare il file matS5\n");
		     exit(1);
                   }
		   fprintf(s1,"# Quinta S-box\n");
		   fprintf(s5,".i 6\n");
		   fprintf(s5,".o 4\n");
       	           fprintf(s5,".ilb x25 x30 x26 x27 x28 x29\n");
		   fprintf(s5,".ob s17 s18 s19 s20\n");
		}
		for(i=0;i<6;i++)
		   fprintf(s5,"%i",input[i]);
		fprintf(s5," ");
		for(i=0;i<4;i++)
		   fprintf(s5,"%i",output[i]);
		fprintf(s5,"\n");
		if(iterazione==63)
		   fclose(s5);
		break;
	case 6: 
		if(iterazione==0)
		{  if((s6=fopen("matS6","wb")==NULL)
		   { printf("Errore: impossibile creare il file matS6\n");
		     exit(1);
                   }
		   fprintf(s1,"# Sesta S-box\n");
		   fprintf(s6,".i 6\n");
		   fprintf(s6,".o 4\n");
   	           fprintf(s6,".ilb x31 x36 x32 x33 x34 x35\n");
		   fprintf(s6,".ob s21 s22 s23 s24\n");
		}
		for(i=0;i<6;i++)
		   fprintf(s6,"%i",input[i]);
		fprintf(s6," ");
		for(i=0;i<4;i++)
		   fprintf(s6,"%i",output[i]);
		fprintf(s6,"\n");
		if(iterazione==63)
		   fclose(s6);
		break;
	case 7: 
		if(iterazione==0)
		{  if((s7=fopen("matS7","wb")==NULL)
		   { printf("Errore: impossibile creare il file matS7");
		     exit(1);
                   }
		   fprintf(s1,"# Settima S-box\n");
		   fprintf(s7,".i 6\n");
		   fprintf(s7,".o 4\n");
		   fprintf(s7,".ilb x37 x42 x38 x39 x40 x41\n");
		   fprintf(s7,".ob s25 s26 s27 s28\n");
		}
		for(i=0;i<6;i++)
		   fprintf(s7,"%i",input[i]);
		fprintf(s7," ");
		for(i=0;i<4;i++)
		   fprintf(s7,"%i",output[i]);
		fprintf(s7,"\n");
		if(iterazione==63)
		   fclose(s7);
		break;
	case 8: 
		if(iterazione==0)
		{  if((s8=fopen("matS8","wb")==NULL)
		   { printf("Errore: impossibile creare il file matS8\n");
		     exit(1);
                   }
		   fprintf(s1,"# Ottava S-box\n");
		   fprintf(s8,".i 6\n");
		   fprintf(s8,".o 4\n");
		   fprintf(s8,".ilb x43 x48 x44 x45 x46 x47\n");
		   fprintf(s8,".ob s29 s30 s31 s32\n");
		}
		for(i=0;i<6;i++)
		   fprintf(s8,"%i",input[i]);
		fprintf(s8," ");
		for(i=0;i<4;i++)
		   fprintf(s8,"%i",output[i]);
		fprintf(s8,"\n");
		if(iterazione==63)
		   fclose(s8);
		break;
        }
}





