/* esa_bin.c: modulo che permette di convertire un blocco in esadecimale
	      in un blocco in binario. Se il numero esadecimale inserito
	       0x1234, il numero 1  considerato come quello meno 
	      significativo. I primi 4 bits di p, invece, saranno 0-0-0-1. */

#include "esa_bin.h"

/* converte in binario il numero esadecimale contenuto nel vettore
   esadecimale[8] (questo vettore accoglie il numero esadecimale spezzato
   in coppie di numeri: ad esempio il numero 0x1234 sar inserito come
   0x12 - 0x34). In numeri esadecimali sono poi rovesciati (esempio 0x21 - 0x43)
   e tradotti in codifica binaria.
   Tale numero binario viene inserito nel vettore b[64].   */
void converti(int esadecimale[], int* b)
{	int count=0;
	int n,h,k,esa,esa1,esa2,esad;
	for(n=0;n<8;n++)
	{  esa=(int)esadecimale[n];
	   esa1=(esa&0x0F);
	   esa2=((esa&0xF0)>>4);
	   for(h=0;h<2;h++)
	   {  switch(h)
	      { case 0: esad=esa2;
		        break;
		case 1: esad=esa1;
		        break;
	      }
              for(k=0;k<4;k++)
	      { switch(esad)
		{  case 0: b[count]=0;
		           b[count+1]=0;
			   b[count+2]=0;
			   b[count+3]=0;
			   break;
		   case 1: b[count]=0;
			   b[count+1]=0;
			   b[count+2]=0;
		           b[count+3]=1;
			   break;
		   case 2: b[count]=0;
			   b[count+1]=0;
			   b[count+2]=1;
			   b[count+3]=0;
			   break;
		   case 3: b[count]=0;
			   b[count+1]=0;
			   b[count+2]=1;
			   b[count+3]=1;
			   break;
		   case 4: b[count]=0;
			   b[count+1]=1;
			   b[count+2]=0;
			   b[count+3]=0;
			   break;
		   case 5: b[count]=0;
			   b[count+1]=1;
			   b[count+2]=0;
			   b[count+3]=1;
			   break;
		   case 6: b[count]=0;
			   b[count+1]=1;
			   b[count+2]=1;
			   b[count+3]=0;
			   break;
		   case 7: b[count]=0;
			   b[count+1]=1;
			   b[count+2]=1;
			   b[count+3]=1;
			   break;
		   case 8: b[count]=1;
			   b[count+1]=0;
			   b[count+2]=0;
			   b[count+3]=0;
			   break;
		   case 9: b[count]=1;
			   b[count+1]=0;
			   b[count+2]=0;
			   b[count+3]=1;
			   break;
		   case 10: b[count]=1;
			    b[count+1]=0;
			    b[count+2]=1;
			    b[count+3]=0;
			    break;
		   case 11: b[count]=1;
			    b[count+1]=0;
			    b[count+2]=1;
			    b[count+3]=1;
			    break;
		   case 12: b[count]=1;
			    b[count+1]=1;
			    b[count+2]=0;
			    b[count+3]=0;
			    break;
		   case 13: b[count]=1;
			    b[count+1]=1;
			    b[count+2]=0;
			    b[count+3]=1;
			    break;
		   case 14: b[count]=1;
			    b[count+1]=1;
			    b[count+2]=1;
			    b[count+3]=0;
			    break;
		   case 15: b[count]=1;
			    b[count+1]=1;
			    b[count+2]=1;
			    b[count+3]=1;
			    break;
		}
	      }
	      count=count+4;
	   }
	}
}









