/* formule.c: modulo che costruisce i files contenenti le formule da
	      analizzare tramite algoritmi di ricerca locale          */

#include "formule.h"
#include <stdio.h>
#include <stdlib.h>
#include "strutt.h"
#include "input.h"

void comune(FILE*,formula*);

/* Funzione che scrive su di un file le formule contenute nella lista id.
   Tale lista contiene le formule di tipo identit: es. A=B.              */                 
void formule(lista_identita* id)
{	static FILE* F_identita;
	formula* temp;
	if((F_identita=fopen(IDENTITA,"w"))==NULL)
	{  printf("Errore: impossibile creare il file identita");
	   exit(1);
	}
        /* Finch ci sono formule ripeti */
	while(id!=0)
	{ /* scrittura su file della parte sinistra della formula */
	  temp=id->identita->parte_sinistra;
          comune(F_identita,temp); 
	  fprintf(F_identita,"=");
          /* scrittura su file della parte destra della formula */
	  temp=id->identita->parte_destra;
	  comune(F_identita,temp);
	  fprintf(F_identita,"\n");
	  id=id->next;
	}
	fclose(F_identita);
}

/* Funzione che scrive su di un file le formule contenute nella lista xor.
   Tale lista contiene le formule di tipo xor: es. A=xor(B,C).            */                 
void formule(lista_xor* xor)
{   static FILE* F_xor;
    formula* temp;
    if((F_xor=fopen(XOR,"w"))==NULL)
    {  printf("Errore: impossibile creare il file xor");
       exit(1);
    }
    while(xor!=0)
    { temp=xor->formula_xor->parte_sinistra;
      /* verifica se la parte sinistra  una variabile o una formula */
      if(temp->succ==0)
	 comune(F_xor,temp);
      else
      {  /* se si tratta di una formula questa sar di tipo xor */
	 fprintf(F_xor,"XOR(");
         while(temp!=0)
         {  comune(F_xor,temp);
	    temp=temp->succ;
            if(temp!=0)
	       fprintf(F_xor,";");
         }
	 fprintf(F_xor,")");
      }
      fprintf(F_xor,"=");
      temp=xor->formula_xor->parte_destra;
      /* verifica se la parte destra  una variabile o una formula */
      if(temp->succ==0)
      {  comune(F_xor,temp);
	 fprintf(F_xor,"\n");
      } 
      else
      {  /* se si tratta di una formula questa sar di tipo xor */
	 fprintf(F_xor,"XOR(");
         while(temp!=0)
	 {  comune(F_xor,temp);
	    temp=temp->succ;
	    if(temp!=0)
               fprintf(F_xor,";");
         }
	 fprintf(F_xor,")\n");
      }
      xor=xor->next;
    }
    fclose(F_xor);
}

/* Funzione che scrive su di un file le formule contenute nella lista and.
   Tale lista contiene le formule di tipo and: es. A=and(B,C).            */                 
void formule(lista_and* and)
{       static FILE* F_and;
	formula* temp;
	if((F_and=fopen(AND,"w"))==NULL)
	{  printf("Errore: impossibile creare il file and");
	   exit(1);
	}
	while(and!=0)
	{ temp=and->formula_and->parte_sinistra;
	  /* verifica se la parte sinistra  una variabile o una formula */
	  if(temp->succ==0)
	     comune(F_and,temp);
	  else
	  {  /* se si tratta di una formula questa sar di tipo and */
	     fprintf(F_and,"AND(");
             while(temp!=0)
	     {  comune(F_and,temp);
	        temp=temp->succ;
		if(temp!=0)
		   fprintf(F_and,";");
             }
	     fprintf(F_and,")");
	  }
	  fprintf(F_and,"=");
	  temp=and->formula_and->parte_destra;
	  /* verifica se la parte destra  una variabile o una formula */
	  if(temp->succ==0)
	  {  comune(F_and,temp);
	     fprintf(F_and,"\n");
          }
	  else
	  {  /* se si tratta di una formula questa sar di tipo and */
	     fprintf(F_and,"AND(");
             while(temp!=0)
	     {  comune(F_and,temp);
	        temp=temp->succ;
		if(temp!=0)
		   fprintf(F_and,";");
             }
	     fprintf(F_and,")\n");
	  }
	  and=and->next;
	}
	fclose(F_and);
}

/* Funzione che scrive su di un file le formule contenute nella lista or.
   Tale lista contiene le formule di tipo or: es. A=or(B,C).            */
void formule(lista_or* or)
{	static FILE* F_or;
	formula* temp;
	if((F_or=fopen(OR,"w"))==NULL)
	{  printf("Errore: impossibile creare il file or");
	   exit(1);
	}
	while(or!=0)
	{ temp=or->formula_or->parte_sinistra;
	  /* verifica se la parte sinistra  una variabile o una formula */
	  if(temp->succ==0)
	     comune(F_or,temp);
	  else
	  {  /* se si tratta di una formula questa sar di tipo or */
	     fprintf(F_or,"OR(");
             while(temp!=0)
	     {  comune(F_or,temp);
	        temp=temp->succ;
		if(temp!=0)
		   fprintf(F_or,";");
             }
	     fprintf(F_or,")");
	  }
	  fprintf(F_or,"=");
	  temp=or->formula_or->parte_destra;
	  /* verifica se la parte destra  una variabile o una formula */
	  if(temp->succ==0)
	  {  comune(F_or,temp);
	     fprintf(F_or,"\n");
          }
	  else
	  {  /* se si tratta di una formula questa sar di tipo or */
	     fprintf(F_or,"OR(");
             while(temp!=0)
	     {  comune(F_or,temp);
	        temp=temp->succ;
		if(temp!=0)
	           fprintf(F_or,";");
             }
	     fprintf(F_or,")\n");
	  }
	  or=or->next;
	}
    fclose(F_or);
}

/* Funzione che scrive nel file ins_file l'elemento temp di una formula.  */
void comune(FILE* ins_file,formula* temp)
{       /* verifica se l'elemento  una variabile, oppure true o false */
	if(temp->tipo_elemento==VARIABILE)
	{  if(!temp->var->negata)
	   { fprintf(ins_file,"%c",temp->var->nome);
             fprintf(ins_file,"%i",temp->var->posizione_bit);
             fprintf(ins_file,",");
   	     fprintf(ins_file,"%i",temp->var->numero_iterazione);
	     fprintf(ins_file,",");
	     fprintf(ins_file,"%i",temp->var->numero_blocco);
           }
	   else
	   /* se la variabile  negata aggiunge il not */
	   { fprintf(ins_file,"NOT(");
	     fprintf(ins_file,"%c",temp->var->nome);
	     fprintf(ins_file,"%i",temp->var->posizione_bit);
	     fprintf(ins_file,",");
	     fprintf(ins_file,"%i",temp->var->numero_iterazione);
	     fprintf(ins_file,",");
	     fprintf(ins_file,"%i",temp->var->numero_blocco);
	     fprintf(ins_file,")");
           }
	}
	else if(temp->tipo_elemento==TRUE)
	        fprintf(ins_file,"TRUE");
	     else fprintf(ins_file,"FALSE");
}
