/* ins_01.c : modulo che si occupa di inserire nel circuito i valori di 
              verita' associati al plaintext ed al ciphertext */

#include <stdio.h>
#include "ins_01.h"
#include "strutt.h"

extern lista_identita* identity;
extern lista_identita* ultimo;
extern lista_xor* xor;

void ins_01(int,formula*);
void ins_plain(int,formula*);
void ins_cipher(int,formula*);
formula* contiene(formula*,formula*,int&);
void in_lista_iden(definizione*);

/* Inserisce nella lista delle identita' le formule del tipo L[0]= TRUE o FALSE 
   e R[0]= TRUE o FALSE */
void inserisci_01_plain(int* plain, int n, int k)
/* k=numero blocco; n=iterazioni di DES eseguite */
{	int i;
	definizione* id;
	/* Inserimento formule del tipo L[0]= TRUE o FALSE nella lista 
	   delle identita' */
	for(i=0;i<32;i++)
	{  id=new definizione;
	   id->parte_destra=new formula;
	   id->parte_sinistra=new formula;
	   id->parte_destra->var=new variabile;
	   id->parte_sinistra->succ=0;
	   id->parte_sinistra->var=0;
	   if(plain[i]==0)
	      id->parte_sinistra->tipo_elemento=FALSE;
	   else id->parte_sinistra->tipo_elemento=TRUE;
	   id->parte_destra->tipo_elemento=VARIABILE;
	   id->parte_destra->succ=0;
	   id->parte_destra->var->nome='L';
	   id->parte_destra->var->posizione_bit=i+1;
	   id->parte_destra->var->numero_iterazione=0;
	   id->parte_destra->var->numero_blocco=k;
	   id->parte_destra->var->negata=0;
	   in_lista_iden(id);
	}	
	/* Inserimento formule del tipo R[0]= TRUE o FALSE nella lista 
	   delle identita' */
	for(i=0;i<32;i++)
	{  id=new definizione;
	   id->parte_destra=new formula;
	   id->parte_sinistra=new formula;
	   id->parte_destra->var=new variabile;
	   id->parte_sinistra->succ=0;
	   id->parte_sinistra->var=0;
	   if(plain[32+i]==0)
	      id->parte_sinistra->tipo_elemento=FALSE;
	   else id->parte_sinistra->tipo_elemento=TRUE;
	   id->parte_destra->tipo_elemento=VARIABILE;
	   id->parte_destra->succ=0;
	   id->parte_destra->var->nome='R';
	   id->parte_destra->var->posizione_bit=i+1;
	   id->parte_destra->var->numero_iterazione=0;
	   id->parte_destra->var->numero_blocco=k;
	   id->parte_destra->var->negata=0;
	   in_lista_iden(id);
	}
}

/* Inserisce nella lista delle identita' le formule del tipo L[ultimo_round]= TRUE o FALSE 
   e R[ultimo_round]= TRUE o FALSE */
void inserisci_01_cipher(int* cipher, int n, int k)
/* k=numero blocco; n=iterazioni di DES eseguite */
{	int i;
	definizione* id;
	/* Inserimento formule del tipo R[ultimo_round]= TRUE o FALSE nella lista 
	   delle identita' */
	for(i=0;i<32;i++)
	{  id=new definizione;
	   id->parte_destra=new formula;
	   id->parte_sinistra=new formula;
	   id->parte_destra->var=new variabile;
	   id->parte_sinistra->succ=0;
	   id->parte_sinistra->var=0;
	   if(cipher[i]==0)
	      id->parte_sinistra->tipo_elemento=FALSE;
	   else id->parte_sinistra->tipo_elemento=TRUE;
	   id->parte_destra->tipo_elemento=VARIABILE;
	   id->parte_destra->succ=0;
	   id->parte_destra->var->nome='R';
	   id->parte_destra->var->posizione_bit=i+1;
	   id->parte_destra->var->numero_iterazione=n;
	   id->parte_destra->var->numero_blocco=k;
	   id->parte_destra->var->negata=0;
	   in_lista_iden(id);
	}	
	/* Inserimento formule del tipo L[ultimo_round]= TRUE o FALSE nella lista 
	   delle identita' */
	for(i=0;i<32;i++)
	{  id=new definizione;
	   id->parte_destra=new formula;
	   id->parte_sinistra=new formula;
	   id->parte_destra->var=new variabile;
	   id->parte_sinistra->succ=0;
	   id->parte_sinistra->var=0;
	   if(cipher[32+i]==0)
	      id->parte_sinistra->tipo_elemento=FALSE;
	   else id->parte_sinistra->tipo_elemento=TRUE;
	   id->parte_destra->tipo_elemento=VARIABILE;
	   id->parte_destra->succ=0;
	   id->parte_destra->var->nome='L';
	   id->parte_destra->var->posizione_bit=i+1;
	   id->parte_destra->var->numero_iterazione=n;
	   id->parte_destra->var->numero_blocco=k;
	   id->parte_destra->var->negata=0;
	   in_lista_iden(id);
	}
}
/* Inserisce nella lista delle identita' le formule del tipo L[0]=IP[P] 
   e R[0]=IP[P] */

void inserisci_plain(int* perm, int n, int k)
/* k=numero blocco; n=iterazioni di DES eseguite */
{	int i;
	definizione* id;
	/* Inserimento formule del tipo L[0]= IP[P] nella lista 
	   delle identita' */
	for(i=0;i<32;i++)
	{  id=new definizione;
	   id->parte_destra=new formula;
	   id->parte_sinistra=new formula;
	   id->parte_destra->var=new variabile;
	   id->parte_sinistra->succ=0;
	   id->parte_sinistra->var=new variabile;
	   id->parte_sinistra->tipo_elemento=VARIABILE;
	   id->parte_sinistra->succ=0;
	   id->parte_sinistra->var->nome='L';
	   id->parte_sinistra->var->posizione_bit=i+1;
	   id->parte_sinistra->var->numero_iterazione=0;
	   id->parte_sinistra->var->numero_blocco=k;
	   id->parte_sinistra->var->negata=0;
	   id->parte_destra->tipo_elemento=VARIABILE;
	   id->parte_destra->succ=0;
	   id->parte_destra->var->nome='P';
	   id->parte_destra->var->posizione_bit=perm[i];
	   id->parte_destra->var->numero_iterazione=0;
	   id->parte_destra->var->numero_blocco=k;
	   id->parte_destra->var->negata=0;
	   in_lista_iden(id);
	}	
	/* Inserimento formule del tipo R[0]= IP[P] nella lista 
	   delle identita' */
	for(i=0;i<32;i++)
	{  id=new definizione;
	   id->parte_destra=new formula;
	   id->parte_sinistra=new formula;
	   id->parte_destra->var=new variabile;
	   id->parte_sinistra->succ=0;
	   id->parte_sinistra->var=new variabile;
	   id->parte_sinistra->tipo_elemento=VARIABILE;
	   id->parte_sinistra->succ=0;
	   id->parte_sinistra->var->nome='R';
	   id->parte_sinistra->var->posizione_bit=i+1;
	   id->parte_sinistra->var->numero_iterazione=0;
	   id->parte_sinistra->var->numero_blocco=k;
	   id->parte_sinistra->var->negata=0;
	   id->parte_destra->tipo_elemento=VARIABILE;
	   id->parte_destra->succ=0;
	   id->parte_destra->var->nome='P';
	   id->parte_destra->var->posizione_bit=perm[32+i];
	   id->parte_destra->var->numero_iterazione=0;
	   id->parte_destra->var->numero_blocco=k;
	   id->parte_destra->var->negata=0;
	   in_lista_iden(id);
	}
}

/* Inserisce nella lista delle identita' le formule del tipo L[ultimo_round]=IP[C] 
   e R[ultimo_round]=IP[C] */
void inserisci_cipher(int* perm, int n, int k)
/* k=numero blocco; n=iterazioni di DES eseguite */
{	int i;
	definizione* id;
	/* Inserimento formule del tipo R[ultimo_round]= IP[C] nella lista 
	   delle identita' */
	for(i=0;i<32;i++)
	{  id=new definizione;
	   id->parte_destra=new formula;
	   id->parte_sinistra=new formula;
	   id->parte_destra->var=new variabile;
	   id->parte_sinistra->succ=0;
	   id->parte_sinistra->var=new variabile;
	   id->parte_sinistra->tipo_elemento=VARIABILE;
	   id->parte_sinistra->succ=0;
	   id->parte_sinistra->var->nome='R';
	   id->parte_sinistra->var->posizione_bit=i+1;
	   id->parte_sinistra->var->numero_iterazione=n;
	   id->parte_sinistra->var->numero_blocco=k;
	   id->parte_sinistra->var->negata=0;
	   id->parte_destra->tipo_elemento=VARIABILE;
	   id->parte_destra->succ=0;
	   id->parte_destra->var->nome='C';
	   id->parte_destra->var->posizione_bit=perm[i];
	   id->parte_destra->var->numero_iterazione=0;
	   id->parte_destra->var->numero_blocco=k;
	   id->parte_destra->var->negata=0;
	   in_lista_iden(id);
	}	
	/* Inserimento formule del tipo L[ultimo_round]= IP[C] nella lista 
	   delle identita' */
	for(i=0;i<32;i++)
	{  id=new definizione;
	   id->parte_destra=new formula;
	   id->parte_sinistra=new formula;
	   id->parte_destra->var=new variabile;
	   id->parte_sinistra->succ=0;
	   id->parte_sinistra->var=new variabile;
	   id->parte_sinistra->tipo_elemento=VARIABILE;
	   id->parte_sinistra->succ=0;
	   id->parte_sinistra->var->nome='L';
	   id->parte_sinistra->var->posizione_bit=i+1;
	   id->parte_sinistra->var->numero_iterazione=n;
	   id->parte_sinistra->var->numero_blocco=k;
	   id->parte_sinistra->var->negata=0;
	   id->parte_destra->tipo_elemento=VARIABILE;
	   id->parte_destra->succ=0;
	   id->parte_destra->var->nome='C';
	   id->parte_destra->var->posizione_bit=perm[32+i];
	   id->parte_destra->var->numero_iterazione=0;
	   id->parte_destra->var->numero_blocco=k;
	   id->parte_destra->var->negata=0;
	   in_lista_iden(id);
	}
}

/* Funzione che verifica se id  contenuto in parte, se cos 
   riporta in elem il puntatore all'elemento di parte uguale a id */
formula* contiene(formula* id, formula* parte, int& trovato)
{   /* Controlla parte finch non trovi id o fino alla fine */
	while(parte!=0)
	{   if((parte->tipo_elemento==VARIABILE)&&
	      (id->var->nome==parte->var->nome)&&
	      (id->var->posizione_bit==parte->var->posizione_bit)&&
	      (id->var->numero_iterazione==parte->var->numero_iterazione)
	      &&(id->var->numero_blocco==parte->var->numero_blocco))
		{ /* Se e' contenuto torna in elem l'elemento che corrisponde a
	         id, e ritorna 1 per la funzione  */                  
	      trovato=1;
	      return parte;
		}
	    parte=parte->succ;
	}
    /* Se arriva qui id non e' contenuto in parte_destra */
	trovato=0;
	return 0;
}

/* Se def e' un'identit la aggiunge alla lista delle identita' */
void in_lista_iden(definizione* def)
{   lista_identita* id;
	id=new lista_identita;
    id->identita=def;
	id->next=0;
	if(ultimo!=0)
	   ultimo->next=id;
	else
	   identity=id;
	ultimo=id;
}
