/* iterades.c: Modulo che svolge il corpo centrale di DES  */

#include "chiave.h"
#include "iterades.h"
#include "scrivi.h"
#include "strutt.h"
#include "S_boxes.h"
#include "leggi_P.h"
#include "leggi_E.h"
//#include "vincoli.h"
#define MAX_VAR 32

variabile variabili[MAX_VAR];
/* il vettore successivo permette di estendere le R(i-1) */
int E[48];
int P[32];

/***************************  Prototipi funzioni  **************************/
void permuta_S(int,int); /* permuta_S(iterazione attuale, numero blocco)   */
void calcola_F(int,int,int,int); 
void itera_DES(int,int); /* itera_DES(numero blocco, numero iterazioni
					        da effettuare)                                 */
void prepara_variabile(char,int,int,int,int,int); /* inserisce una
							                         variabile nel
							                         vettore variabili     */
/***************************************************************************/


void itera_DES(int k, int n, int num_bl, int num_bl_key)
/* k=numero da attribuire al blocco; n=numero iterazioni di DES che devono essere
   effettuate; num_bl=1 se il blocco e' uno solo, k altrimenti 
   num_bl_key= numero da attribuire al blocco relativo alla chiave*/
{	int i, h;
	/* trasforma le S-boxes in formule */
    for(i=1;i<=n;i++)
	{   S_boxes(i,k);
		//vincoli_aggiuntivi(i,k);
	}
	/* inserisce nella lista identita' e nella lista degli xor le
	   formule del tipo L(i)=R(i-1) e R(i)=L(i-1)xorF(i)           */ 
	for(i=1;i<=n;i++)
	{	for(h=1;h<=32;h++)
		{	prepara_variabile('L',h,i,k,0,0);
			prepara_variabile('R',h,i-1,k,0,1);
            prepara_variabile(0,0,0,0,0,2);
			scrivi_in_lista(variabili,0);
			prepara_variabile('R',h,i,k,0,0);
			prepara_variabile('L',h,i-1,k,0,1);
			prepara_variabile('F',h,i,k,0,2);
			prepara_variabile(0,0,0,0,0,3);
			scrivi_in_lista(variabili,1);
		}
		/* sviluppa in formule la funzione f di DES */
		calcola_F(i,k,num_bl,num_bl_key);
	}
}

/* Funzione che sviluppa in formule la parte di DES rappresentata dalla
   funzione f                                                           */
void calcola_F(int i, int k, int num_bl, int num_bl_key)
/* i=numero iterazione; k=numero blocco; num_bl= vedi itera_des
   num_bl_key= numero da attribuire al blocco relativo alla chiave*/
{	int chiave[48];
	leggi_E();
	/* fornisci i bits della chiave necessari per l'iterazione attuale */
	fornisci_chiave(num_bl,i,chiave);
    /* inserisci le formule X(i)=E(i)xorK(i) nella lista degli xor */
	scrivi_in_lista(E,chiave,i,k,num_bl_key);
	/* effettua la permutazione sulle S(i) */
	permuta_S(i,k);
}

/* Effettua la permutazione dei bits uscenti dalle S-boxes. Nel fare cio',
   inserisce nella lista identita' formule del tipo F(i)=S(k)             */
void permuta_S(int i, int k)
/* i=numero iterazione; k=numero blocco */
{	leggi_P();
	scrivi_in_lista(P,i,k);
}

/* Funzione che inserisce nel vettore variabili tutte le informazioni
   necessarie per costruire le formule                                 */
void prepara_variabile(char nome,int h,int i,int k,int neg,int num)
/* nome=nome variabile; h=posizione bit; i=numero iterazione;
   k=numero blocco; neg=switch che indica se la variabile  negata;
   val=attribuisce,eventualmente un valore alla variabile;
   num=posizione del vettore variabili in cui devono essere inserite le
   precedenti informazioni                                              */
{	if(nome==0)
	{  variabili[num].nome=0;
	   return;
    }
	variabili[num].nome=nome;
	variabili[num].posizione_bit=h;
	variabili[num].numero_iterazione=i;
	variabili[num].numero_blocco=k;
	variabili[num].negata=neg;
}