/* main.c : modulo main del programma per analisi crittografica del DES 
            mediante logica booleana */ 

#include "iterades.h"
#include "strutt.h"
#include "minimiz.h"
#include "esa_bin.h"
#include "propagID.h"
#include "permuta.h"
#include "ins_01.h"
#include "valuprop.h"
#include "modif_id.h"
#include "verifica.h"
#include "stampa_fml.h"
#include "stampa_fof.h"
#include "stampa_cnf.h"
#include "stampa_smodel.h"
#include "confron.h"
#include "garbage.h"
#include <stdio.h>
#include <stdlib.h>

// Files contenenti il sistema in vari formati
#define FORMULAE "formulae"
#define FORMAT 4

#define PLAIN "plaintxt"  // File contenente i plaintexts
#define CIPHER "ciph_txt" // File contenente i ciphertexts
#define KEY "key_des"     // File contenente la chiave

lista_identita* identity=0;
lista_identita* ultimo;
lista_identita* id;
lista_xor* xor=0;
lista_xor* ultimo_xor;
lista_and* and=0;
lista_and* ultimo_and;
lista_or* or=0;
lista_or* ultimo_or;
formula* bit_chiave[64];
lista_xor* xor1;
lista_or* or1;
lista_and* and1;

void help(int);

int main(int argc, char* argv[])
{
  int plain[64];
  int key[64];
  int cipher[64];
  int plain_permutato[64];
  int cipher_permutato[64];
  int perm[64];
  int pl[8];
  int k[8];
  int ciph[8];
  int val,cambiato;
  FILE* plain_txt;
  FILE* ciph_txt;
  FILE* key_des;
  FILE* sistema;

  lista_xor* xor2;
  lista_or* or2;
  lista_and* and2;
  int i,j,i1;
  int corretto=0;

  /**** Controllo parametri inseriti ****/
  int n=0;             /* Valore di default per i round */
  int num_blocchi=1;   /* Valore di default per il numero dei blocchi */
  int num=1;           /* Valore di default per il blocco */
  int known_key=0;     /* Indica se si e' a conoscenza della chiave (1) o meno (0) */
  int known_plain=0;         /* Indica se si e' a conoscenza del plaintext (1) o meno (0) */
  int known_ciph=0;         /* Indica se si e' a conoscenza del ciphertext (1) o meno (0) */
  int num_bl_key=1;    /* Valore di default da attribuire al blocco relativo alla chiave */
  int output_format=0; /* Formato di output scelto */

  while((--argc>0)&&(*++argv)[0]=='-')
    switch((*argv)[1]){
    case 'r':
      sscanf(*argv,"-r%d",&n);
      if((n<1)||(n>16)) help(1);
      break;
    case 'k':
      known_key=1;
      break;
    case 'p':
      known_plain=1;
      break;
    case 'c':
      known_ciph=1;
      break;
    case 'b':
      sscanf(*argv,"-b%d",&num_blocchi);
      if(1>num_blocchi) help(2);
      break;
    case 'i':
      sscanf(*argv,"-i%d",&num);
      break;
    case 'j':
      sscanf(*argv,"-j%d",&num_bl_key);
      if(1>num_bl_key) help(4);
      break;
    case 'f':
      sscanf(*argv,"-f%d",&output_format);
      if ((0>output_format)||(output_format>FORMAT-1)) help(6);
      break;
    case 'h':
      help(0);
      break;
    default:
      printf("Illegal option use main -h for help");
      exit(1);
    }
  /* Il numero dei rounds deve essere specificato */
	if(n==0) help(5);
	/* Il numero del blocco puo' essere assegnato solo se il blocco e' uno */
	if((num_blocchi!=1)&&(num!=1)) help(3);
	/* Verifica dell'esistenza dei file contenenti i plaintext, i 
	   ciphertext e la chiave e loro apertura in lettura */
	if(known_plain)
          if((plain_txt=fopen(PLAIN,"r"))==NULL) {
            fprintf(stderr,"Error: file %s doesn't exist\n",PLAIN);
            exit(1);
          }
	if(known_ciph)
          if((ciph_txt=fopen(CIPHER,"r"))==NULL) {
            fprintf(stderr,"Error: file %s doesn't exist\n",CIPHER);
            exit(1);
          }
	if(known_key) {
          if((key_des=fopen(KEY,"r"))==NULL) {
            fprintf(stderr,"Error: file %s doesn't exist\n",KEY);
	    exit(1);
          }
          /* Lettura chiave */
          for(i1=1;i1<=num_bl_key;i1++)
            if(!feof(key_des)) {
              for(i=0;i<8;i++) {
                fscanf(key_des,"%4x",&val);
                k[i]=val&0x00ff;
              }
              /* Visualizzazione del valore della chiave se nota*/
              converti(k,key);
            }
            else {
              fprintf(stderr,"Key blocks are less than %i\n",num_bl_key);
              if(known_plain) fclose(plain_txt);
              if(known_key) fclose(key_des);
           if(known_ciph) fclose(ciph_txt);
	   exit(1);
            }
	}
	/**** Apertura del file contenente la codifica ****/
	if((sistema=fopen(FORMULAE,"w"))==NULL) {
          fprintf(stderr,"Error: can't create file %s\n",FORMULAE);
	  exit(1);
	}
	/**** Generazione codifica ****/
        for(j=1;j<=num_blocchi;j++) {
          if(num_blocchi>1)
            printf("\n####### Block number %d #######\n",j);
          else
            printf("\n####### Block number %d #######\n",num);
          if(known_plain) {
            /* Lettura blocco plaintext */
            for(i1=1;i1<=num;i1++)
              if(!feof(plain_txt)) {
                for(i=0;i<8;i++) {
                  fscanf(plain_txt,"%4x",&val);
                  pl[i]=val&0x00ff;
                }
              }
              else {
                if(num_blocchi==1)
                  printf("Plaintext blocks are less than %i\n",num);
                else
                  printf("Plaintext blocks are less than %i\n",num_blocchi);
                if(known_plain) fclose(plain_txt);
                if(known_key) fclose(key_des);
                if(known_ciph) fclose(ciph_txt);
                fclose(sistema);
                exit(1);
              }
          }
          if(known_ciph) {
            /* Lettura blocco ciphertext */
            for(i1=1;i1<=num;i1++)
              if(!feof(ciph_txt)) {
                for(i=0;i<8;i++) {
                  fscanf(ciph_txt,"%4x",&val);
                  ciph[i]=val&0x00ff;
	        }
              }
              else {
                if(num_blocchi==1)
                  fprintf(stderr,"Ciphertext blocks are less than %i\n",num);
                else
                  fprintf(stderr,"Ciphertext blocks are less than %i\n",num_blocchi);
		if(known_plain)	fclose(plain_txt);
		if(known_key) fclose(key_des);
                if(known_ciph) fclose(ciph_txt);
		fclose(sistema);
                exit(1);
              }
          }
          if(num_blocchi==1)
            itera_DES(num,n,1,num_bl_key);
          else
            itera_DES(j,n,j,num_bl_key);
          if(known_plain) {
            converti(pl,plain);
            /* Visualizza blocco plaintext */
            printf("Plaintext: ");
            for(i=0;i<8;i++)
              printf("%02x",(unsigned int)pl[i]&0x00ff);
            printf("\n");
          }
          if(known_ciph) {
            converti(ciph,cipher);
            /* Visualizza blocco ciphertext */
            printf("Ciphertext (after %i round/rounds): ",n);
            for(i=0;i<8;i++)
              printf("%02x",(unsigned int)ciph[i]&0x00ff);
            printf("\n");
          }
	  /* Permutazioni su blocchi plaintext e ciphertext,
             inserimento bit e propagazione delle identita' */
          if(known_plain) {
            permuta_plaintext(plain,plain_permutato);
            if(num_blocchi==1)
              inserisci_01_plain(plain_permutato,n,num);
            else
              inserisci_01_plain(plain_permutato,n,j);
          }
          else {
            permutazione(perm);
	    if(num_blocchi==1)
              inserisci_plain(perm,n,num);
            else
              inserisci_plain(perm,n,j);
          }

          if(known_ciph) {
            permuta_plaintext(cipher,cipher_permutato);
          if(num_blocchi==1)
            inserisci_01_cipher(cipher_permutato,n,num);
          else
            inserisci_01_cipher(cipher_permutato,n,j);
          }
          else {
            permutazione(perm);
            if(num_blocchi==1)
              inserisci_cipher(perm,n,num);
            else
              inserisci_cipher(perm,n,j);
          }

          if (known_key) {
            inserisci_bit_chiave(key,num_bl_key);
            /* Visualizza chiave */
            printf("Key: ");
            for(i=0;i<8;i++)
              printf("%02x",(unsigned int)k[i]&0x00ff);
            printf("\n");
          }
          cambiato=1;
          /**** Valutatore ****/

          while(cambiato) {
            cambiato=0;
            normalizza_listaID();
            propaga_in_listaID();
            propaga_identita();
            id=identity;
            // garbage(1);
            identity=0;
            ultimo=0;
            valutatore_proposizionale(cambiato);
          }

          switch(output_format) {
          case 0:
            scrivi_fml(sistema);
            break;
          case 1:
            scrivi_cnf(sistema);
            break;
          case 2:
            scrivi_fof(sistema);
            break;
          case 3:
            scrivi_smodel(sistema);
            break;
          }
          /* Azzeramento delle liste */
          id=identity;
          // garbage(1);
          identity=0;
          ultimo=0;
          xor1=xor;
          // garbage(2);
          xor=0;
          ultimo_xor=0;
          and1=and;
          // garbage(4);
          and=0;
          ultimo_and=0;
          or1=or;
          // garbage(3);
          or=0;
          ultimo_or=0;
        }
	/**** Chiusura dei file ****/
        if(known_plain)	fclose(plain_txt);
        if(known_key) fclose(key_des);
        if(known_ciph) fclose(ciph_txt);
        fclose(sistema);
}

/* Funzione di help, contenente i messaggi per interagire con l'utente */
void help(int tag)
{
  switch(tag){
  case 0:
    printf("Usage: des2fml -r<n> [options]\n");
    printf("         # where n is the number of rounds.\n");
    printf("The following options are allowed:\n");
    printf("  -k     # The key is known (file key_des).\n");
    printf("  -p     # The plaintext is known (file plaintxt).\n");
    printf("  -c     # The ciphertext is known (file ciph_txt).\n");
    printf("  -b<n>  # Generate n pairs of plain/ciphertext (default 1).\n");
    printf("           With the -p or -c option, it reads n blocks of\n");
    printf("           plaintext or ciphertext from the corresponding files\n");
    printf("  -i<n>  # Generate the n-th pair of plain/ciphertext\n");
    printf("           Use this option to generate n pairs piecewise\n");
    printf("           With the -p or -c option, it reads the n-th block of \n");
    printf("           plaintext or ciphertext from the corresponding files\n");
    printf("  -j<n>   # Use the n-th key.\n");
    printf("            With the -k option, it reads the n-th key from key_des\n");
    printf(" -f<n>    # Choose the format of the output\n");
    printf("            0 - Human readable format (default)\n");
    printf("            1 - CNF in list format\n");
    printf("            2 - TPTP library format\n");
    printf("            3 - SMODEL format\n");
    break;
  case 1:
    printf("Error: The number of the iterations have to be between 1 and 16!\n");
    break;
  case 2:
    printf("Error: The number of the blocks have to be equal or greater than 1!\n");
    break;
  case 3:
    printf("Error: There is more than one block. -n option is illegal!\n");
    break;
  case 4:
    printf("Error: The number associated to the key have to be greater than 1!\n");
    break;
  case 5:
    printf("Error: The number of the rounds have to be specified!\n");
    break;
  case 6:
    printf("Error: Output formats can be from 0 to %d\n",FORMAT);
    break;
  }
  printf("Option -h for help.\n");

  exit(1);
}

