/* modif_id.c: modulo che effettua una serie di aggiustamenti sulla lista
	       delle identita'.                                           */

#include "modif_id.h"
#include "strutt.h"
#include "comune.h"
#include <stdio.h>
#include <stdlib.h>

extern lista_identita* identity;

void normalizza(definizione*);

/* Funzione che effettua i seguenti aggiustamenti sulla lista delle identita':
   FALSE=TRUE        ==>  TRUE=FALSE
   FALSE=FALSE       ==>  TRUE=TRUE
   FALSE=(NOT X)     ==>  X=TRUE
   FALSE=X           ==>  X=FALSE
   TRUE=FALSE        ==>  ASSURDO
   TRUE=TRUE         ==>  elimina l'identita' dalla lista
   TRUE=(NOT X)      ==>  X=FALSE
   TRUE=X            ==>  X=TRUE
   X=(NOT X)         ==>  TRUE=FALSE
   X=X               ==>  TRUE=TRUE
  (NOT X)=(NOT X)    ==>  TRUE=TRUE
  (NOT X)=TRUE       ==>  X=FALSE
  (NOT X)=FALSE      ==>  X=TRUE
  (NOT X)=Y          ==>  X=(NOT Y)
  (NOT X)=(NOT Y)    ==>  X=Y                                                   */
void normalizza_listaID()
{	lista_identita* scorri;
	lista_identita* precedente;
    formula* sinistra;
	formula* destra;
    scorri=identity;
	/* si tiene traccia dell'elemento precedente per poter eliminare, all'occorrenza,
	   alcuni elementi dalla lista delle identita'.                                   */
	precedente=identity;
	while(scorri!=0)
	{  normalizza(scorri->identita);
	   sinistra=scorri->identita->parte_sinistra;
       destra=scorri->identita->parte_destra;
	   if(sinistra->tipo_elemento==TRUE)
	      if(destra->tipo_elemento==FALSE)
	      {  printf("Error: an absurd have been obtained.\n");
			 printf("       With the values specified the system isn't satisfiable!\n");
		     exit(1);
		  }
	      else if(destra->tipo_elemento==TRUE)
	           {  if(scorri==precedente)
	              {  identity=scorri->next;
	                 precedente=scorri->next; }
		          else precedente->next=scorri->next;
		          scorri=scorri->next;
		          continue;
               }
	   if(scorri!=precedente)
	      precedente=precedente->next;
	   scorri=scorri->next;
	}
}

void normalizza(definizione* id)
{	formula* sinistra;
	formula* destra;
	sinistra=id->parte_sinistra;
	destra=id->parte_destra;
    if(sinistra->tipo_elemento==FALSE)
	   if(destra->tipo_elemento==TRUE)
	   {  sinistra->tipo_elemento=TRUE;
	      destra->tipo_elemento=FALSE;
		  return;
	   }
	   else 
		if(destra->tipo_elemento==FALSE)
		{ sinistra->tipo_elemento=TRUE;
          destra->tipo_elemento=TRUE; 
		  return;
		}		         
	    else 
		 if(destra->var->negata==1)
		 { sinistra->tipo_elemento=VARIABILE;
		   if(sinistra->var==0)
		      sinistra->var=new variabile;
		   copia_var_non_negata(sinistra,destra);
		   destra->tipo_elemento=TRUE;
		   return;
         }
         else
		 { sinistra->tipo_elemento=VARIABILE;
		   if(sinistra->var==0)
		      sinistra->var=new variabile;
		   copia_var_non_negata(sinistra,destra);
		   destra->tipo_elemento=FALSE;
		   return;
         }
	if(sinistra->tipo_elemento==TRUE)
	  if(destra->tipo_elemento==FALSE)
	     return;
	  else if(destra->tipo_elemento==TRUE)
	          return;
	       else 
			 if(destra->var->negata==1)
			 {  sinistra->tipo_elemento=VARIABILE;
		        if(sinistra->var==0)
		           sinistra->var=new variabile;
		        copia_var_non_negata(sinistra,destra);
		        destra->tipo_elemento=FALSE;
				return;
			 }
             else
			 {  sinistra->tipo_elemento=VARIABILE;
		        if(sinistra->var==0)
		           sinistra->var=new variabile;
		        copia_var_non_negata(sinistra,destra);
		        destra->tipo_elemento=TRUE;
				return;
             }
	if(variabili_uguali(sinistra,destra))
	{ if(sinistra->var->negata!=destra->var->negata)
	  {  sinistra->tipo_elemento=TRUE;
	     destra->tipo_elemento=FALSE;
		 return; }
	  else
	  {  sinistra->tipo_elemento=TRUE;
	     destra->tipo_elemento=TRUE;
		 return;
      }
    }
	else
	{ if(sinistra->var->negata==1)
	  {  sinistra->var->negata=0;
	     if(destra->tipo_elemento==TRUE)
	        destra->tipo_elemento=FALSE;
	     else if(destra->tipo_elemento==FALSE)
	             destra->tipo_elemento=TRUE;
	          else if(destra->var->negata==0)
		              destra->var->negata=1;
		           else destra->var->negata=0;
      }
	}
}