/* propagID.c : modulo che effettua la propagazione delle identita' nelle
                altre liste */

#include "strutt.h"
#include "propagID.h"
#include "comune.h"
#include <stdio.h>

extern lista_identita* identity;
extern lista_xor* xor;
extern lista_and* and;
extern lista_or* or;

/*************************** Prototipi funzioni ***************************/
void propaga_identita();
void sostituisci(formula* ,formula*);
formula* contenuto(formula* ,formula* ,int&);
/**************************************************************************/

void propaga_identita()
{	lista_identita* scorri_id;
	lista_xor* scorri_xor;
	lista_and* scorri_and;
	lista_or* scorri_or;
	formula* elem;
	formula* parte;
	int trovato; 
	scorri_id=identity;
        /* controlla tutti gli elementi della lista identita' */
        while(scorri_id!=0)
	{   scorri_xor=xor;
            parte=scorri_id->identita->parte_sinistra;
	    /* controlla parte con tutti gli elementi della lista xor per
	       vedere se e' contenuta in qualche formula  */
            while(scorri_xor!=0)
	    {  elem=scorri_xor->formula_xor->parte_destra;
	       while(elem!=0)
	       {  /* se e' contenuta allora sostituisci */
                  if(uguali(parte,elem))
		     sostituisci(scorri_id->identita->parte_destra,elem);
		  elem=elem->succ;
	       }   
	       elem=scorri_xor->formula_xor->parte_sinistra;
	       /* se e' contenuta allora sostituisci */
               if(uguali(parte,elem))
		  sostituisci(scorri_id->identita->parte_destra,elem);
	       scorri_xor=scorri_xor->next;
	    }
	    scorri_id=scorri_id->next;
    }
    scorri_id=identity;
    while(scorri_id!=0)
    {  scorri_or=or;
       parte=scorri_id->identita->parte_sinistra;
       /* controlla parte con tutti gli elementi della lista or per
	      vedere se e' contenuta in qualche formula  */
       while(scorri_or!=0)
       {   elem=scorri_or->formula_or->parte_destra;
           while(elem!=0)
           {  /* se e' contenuta allora sostituisci */
              if(uguali(parte,elem))
		 sostituisci(scorri_id->identita->parte_destra,elem);
	      elem=elem->succ;
	   }   
	   elem=scorri_or->formula_or->parte_sinistra;
	   /* se e' contenuta allora sostituisci */
           if(uguali(parte,elem))
	      sostituisci(scorri_id->identita->parte_destra,elem);
           scorri_or=scorri_or->next;
       }
       scorri_id=scorri_id->next;
    }
    scorri_id=identity;
    while(scorri_id!=0)
    {  scorri_and=and;
       parte=scorri_id->identita->parte_sinistra;
       /* controlla parte con tutti gli elementi della lista and per
	      vedere se e' contenuta in qualche formula  */
       while(scorri_and!=0)
       {   elem=scorri_and->formula_and->parte_destra;
           while(elem!=0)
           {  /* se e' contenuta allora sostituisci */
              if(uguali(parte,elem))
		 sostituisci(scorri_id->identita->parte_destra,elem);
	      elem=elem->succ;
	   }   
	   elem=scorri_and->formula_and->parte_sinistra;
	   /* se e' contenuta allora sostituisci */
           if(uguali(parte,elem))
              sostituisci(scorri_id->identita->parte_destra,elem);
	   scorri_and=scorri_and->next;
       }
       scorri_id=scorri_id->next;
    }
}

/* Funzione che sostituisce elem con valore a seconda di certe regole */
void sostituisci(formula* valore, formula* elem)
{   if(valore->tipo_elemento==VARIABILE)
    {  if(valore->var->negata!=0)
       {  if(elem->var->negata==1)
	     elem->var->negata=0;
          else elem->var->negata=1;                 
       }
       copia_var(elem,valore);
    }
    else
    { if(elem->var->negata==0)
         elem->tipo_elemento=valore->tipo_elemento;
      else if(valore->tipo_elemento==FALSE)
              elem->tipo_elemento=TRUE;
	   else elem->tipo_elemento=FALSE;
    }
}
	   
/* Funzione che verifica se id e' contenuto in parte_destra, se cosi' e'
   riporta in elem il puntatore all'elemento di parte_destra uguale a id */
formula* contenuto(formula* id, formula* parte_destra, int& trovato)
{   /* Controlla parte_destra finche' non trovi id o fino alla fine */
    if(id->tipo_elemento!=VARIABILE)
    {  trovato=0;
       return 0;
    }
    while(parte_destra!=0)
    { if(uguali(id,parte_destra))
      {  /* Se e' contenuto torna in elem l'elemento che corrisponde a
	        id, e ritorna 1 per la funzione  */                  
         trovato=1;
         return parte_destra;
      }
      parte_destra=parte_destra->succ;
    }
    /* Se arriva qui id non e' contenuto in parte_destra */
    trovato=0;
    return 0;
}	   
