/* scrivi_cnf.c: modulo che costruisce i files contenenti le formule in
	           formato numerico da analizzare tramite algoritmi di
	           ricerca locale                                           */

#include <stdio.h>
#include "strutt.h"
#include "stampa_cnf.h"

extern lista_and* and;
extern lista_or* or;
extern lista_xor* xor;
extern lista_identita* id;

#define POS 1
#define NEG -1

/* Funzione che scrive nel file sis l'elemento temp di una formula.  */
void scrivi_cnf_lit(FILE* sis,formula* temp,short segno)
{
  long KEYBITS,MAXITER,MAXVAR,MAXBITS,var, blocco, iterazione, bit, ident;

  if(temp->tipo_elemento==VARIABILE) {
    MAXBITS=1024;
    MAXVAR=8;
    MAXITER=16;

    blocco=(long)temp->var->numero_blocco;
    iterazione=(long)temp->var->numero_iterazione;
    bit=(long)temp->var->posizione_bit;
    --blocco;

    switch(temp->var->nome) {
    case 'K':
      var=0;
      break;
    case 'P':
      var=1;
      break;
    case 'C':
      var=2;
      break;
    case 'X':
      var=3;
      --iterazione;
      break;
    case 'M':
      var=4;
      --iterazione;
      break;
    case 'S':
      var=5;
      --iterazione;
      break;
    case 'R':
      var=6;
      --iterazione;
      break;
    }

    ident=bit+MAXBITS*(var+MAXVAR*(iterazione+MAXITER*blocco));

    if(!temp->var->negata)
      segno*=POS;
    else
      segno*=NEG;

    if (segno==POS)
      fprintf(sis,"%ld",ident);
    else
      fprintf(sis,"%ld",-ident);

  }
  else {
    if(temp->tipo_elemento==TRUE)
      fprintf(sis,"true");
    else fprintf(sis,"false");
  }
}

/* Funzione che scrive su di un file le formule contenute nella lista id.
   Tale lista contiene le formule di tipo identit: es. A=B. */

void scrivi_cnf_fml(FILE* sis,lista_identita* id)
{
  formula *A,*B;
  /* Finch ci sono formule ripeti */
  while(id!=0) {
    A=id->identita->parte_sinistra;
    B=id->identita->parte_destra;

    if (B->tipo_elemento==VARIABILE) {
      /* B -> A */
      fprintf(sis,"( ");
      scrivi_cnf_lit(sis,A,POS);
      fprintf(sis," ");
      scrivi_cnf_lit(sis,B,NEG);
      fprintf(sis," )\n");

      /* A -> B */
      fprintf(sis,"( ");
      scrivi_cnf_lit(sis,A,NEG);
      fprintf(sis," ");
      scrivi_cnf_lit(sis,B,POS);
      fprintf(sis," )\n");
    }
    else {
      fprintf(sis,"( ");
      if (B->tipo_elemento==TRUE)
        scrivi_cnf_lit(sis,A,POS);
      else
        scrivi_cnf_lit(sis,A,NEG);
      fprintf(sis," )\n");
    }
    id=id->next;
    fflush(sis);
  }
}

/* Funzione che scrive su di un file le formule contenute nella lista xor.
   Tale lista contiene le formule di tipo xor: es. A=xor(B,C).            */                 
void scrivi_cnf_fml(FILE* sis,lista_xor* xor)
{
  formula *A,*B,*C;
  while(xor!=0) {
    A=xor->formula_xor->parte_sinistra;
    B=xor->formula_xor->parte_destra;
    C=B->succ;
    if (A->tipo_elemento==VARIABILE) {
      /* ~A -> ~B v C */
      fprintf(sis,"( ");
      scrivi_cnf_lit(sis,A,POS);
      fprintf(sis," ");
      scrivi_cnf_lit(sis,B,NEG);
      fprintf(sis," ");
      scrivi_cnf_lit(sis,C,POS);
      fprintf(sis," )\n");

      /* ~A -> B v ~C */
      fprintf(sis,"( ");
      scrivi_cnf_lit(sis,A,POS);
      fprintf(sis," ");
      scrivi_cnf_lit(sis,B,POS);
      fprintf(sis," ");
      scrivi_cnf_lit(sis,C,NEG);
      fprintf(sis," )\n");

      /* A -> B v C */
      fprintf(sis,"( ");
      scrivi_cnf_lit(sis,A,NEG);
      fprintf(sis," ");
      scrivi_cnf_lit(sis,B,POS);
      fprintf(sis," ");
      scrivi_cnf_lit(sis,C,POS);
      fprintf(sis," )\n");

      /* A -> ~B v ~C */
      fprintf(sis,"( ");
      scrivi_cnf_lit(sis,A,NEG);
      fprintf(sis," ");
      scrivi_cnf_lit(sis,B,NEG);
      fprintf(sis," ");
      scrivi_cnf_lit(sis,C,NEG);
      fprintf(sis," )\n");

    }
    else {
      if (A->tipo_elemento==TRUE) {
        /* B v C */
        fprintf(sis,"( ");
        scrivi_cnf_lit(sis,B,POS);
	fprintf(sis," ");
        scrivi_cnf_lit(sis,C,POS);
        fprintf(sis," )\n");
	
		           /* ~B v ~C */
        fprintf(sis,"( ");
        scrivi_cnf_lit(sis,B,NEG);
	fprintf(sis," ");
        scrivi_cnf_lit(sis,C,NEG);
        fprintf(sis," )\n");
      }
      else {
        /* B v ~C */
        fprintf(sis,"( ");
        scrivi_cnf_lit(sis,B,POS);
	fprintf(sis," ");
        scrivi_cnf_lit(sis,C,NEG);
        fprintf(sis," )\n");

        /* ~B v C */
        fprintf(sis,"( ");
        scrivi_cnf_lit(sis,B,NEG);
	fprintf(sis," ");
        scrivi_cnf_lit(sis,C,POS);
        fprintf(sis," )\n");
      }
    }
    xor=xor->next;
    fflush(sis);
  }
}

/* Funzione che scrive su di un file le formule contenute nella lista and.
   Tale lista contiene le formule di tipo and: es. A=and(B,C).            */                 
void scrivi_cnf_fml(FILE* sis,lista_and* and)
{
  formula *A,*B,*Def;
  while(and!=0) {
    A=and->formula_and->parte_sinistra;
    Def=and->formula_and->parte_destra;
    if (A->tipo_elemento==VARIABILE) {
      /* A <- and(B1,...,Bn) */
      fprintf(sis,"( ");
      scrivi_cnf_lit(sis,A,POS);
      for(B=Def; B!=0; B=B->succ) {
	fprintf(sis," ");
        scrivi_cnf_lit(sis,B,NEG);
      }
      fprintf(sis," )\n");

      /* A -> and(B1,...,Bn) */
      for(B=Def; B!=0; B=B->succ) {
        fprintf(sis,"( ");
        scrivi_cnf_lit(sis,A,NEG);
	fprintf(sis," ");
        scrivi_cnf_lit(sis,B,POS);
        fprintf(sis," )\n");
      }

    }
    else
      {
        if (A->tipo_elemento==TRUE) {
          /* and(B1,...,Bn) */
          for(B=Def; B!=0; B=B->succ) {
            fprintf(sis,"( ");
            scrivi_cnf_lit(sis,B,POS);
	    fprintf(sis," )\n");

          }
        }
        else {
          /* ~and(B1,...,Bn) */
          fprintf(sis,"( ");
          for(B=Def; B!=0; B=B->succ) {
            scrivi_cnf_lit(sis,B,NEG);
	    if (B->succ!=0)
	      fprintf(sis," ");
          }
          fprintf(sis," )\n");
        }
      }
    and=and->next;
    fflush(sis);
  }
}

/* Funzione che scrive su di un file le formule contenute nella lista or.
   Tale lista contiene le formule di tipo or: es. A=or(B,C).            */

void scrivi_cnf_fml(FILE* sis,lista_or* or)
{
  formula *A,*B,*Def;
  while(or!=0) {
    A=or->formula_or->parte_sinistra;
    Def=or->formula_or->parte_destra;
    if (A->tipo_elemento==VARIABILE) {

      /* A -> or(B1,...,Bn) */
      fprintf(sis,"( ");
      scrivi_cnf_lit(sis,A,NEG);
      for(B=Def; B!=0; B=B->succ) {
        fprintf(sis," ");
        scrivi_cnf_lit(sis,B,POS);
      }
      fprintf(sis," )\n");

      /* A <- or(B1,...,Bn) */
      for(B=Def; B!=0; B=B->succ) {
        fprintf(sis,"( ");
        scrivi_cnf_lit(sis,B,NEG);
        fprintf(sis," ");
        scrivi_cnf_lit(sis,A,POS);
        fprintf(sis," )\n");
      }

    }
    else {
      if (A->tipo_elemento==TRUE) {
        /* or(B1,...,Bn) */
        fprintf(sis,"( ");
        for(B=Def; B!=0; B=B->succ) {
          scrivi_cnf_lit(sis,B,POS);
	  if (B->succ!=0)
	    fprintf(sis," ");
        }
        fprintf(sis," )\n");
      }
      else {
        /* ~or(B1,...,Bn) */
        for(B=Def; B!=0; B=B->succ) {
          fprintf(sis,"( ");
          scrivi_cnf_lit(sis,B,NEG);
	  fprintf(sis," )\n");
        }
      }
    }
    or=or->next;
    fflush(sis);
  }
}

void scrivi_cnf(FILE* sis)
{
  // scrivi_cnf_fml(sis,id);
  scrivi_cnf_fml(sis,and);
  scrivi_cnf_fml(sis,or);
  scrivi_cnf_fml(sis,xor);
}
















