/* stampa_fml.c: modulo che costruisce il file contenente il sistema di
              formule da analizzare tramite algoritmi di ricerca locale  */

#include <stdio.h>
#include <stdlib.h>
#include "strutt.h"
#include "stampa_fml.h"

extern lista_and* and;
extern lista_or* or;
extern lista_xor* xor;

/* Funzione che scrive nel file ins_file i letterali di una formula.  */

void scrivi_fml_lit(FILE* ins_file,formula* temp)
{   /* verifica se l'elemento  una variabile, oppure true o false */
	if(temp->tipo_elemento==VARIABILE)
	{  if(!temp->var->negata)
	   { fprintf(ins_file,"%c",temp->var->nome);
		 fprintf(ins_file,"%i",temp->var->posizione_bit);
		 fprintf(ins_file,",");
		 fprintf(ins_file,"%i",temp->var->numero_iterazione);
		 fprintf(ins_file,",");
		 fprintf(ins_file,"%i",temp->var->numero_blocco); }
	   else
	   /* se la variabile  negata aggiunge il not */
	   { fprintf(ins_file,"NOT(");
		 fprintf(ins_file,"%c",temp->var->nome);
		 fprintf(ins_file,"%i",temp->var->posizione_bit);
		 fprintf(ins_file,",");
		 fprintf(ins_file,"%i",temp->var->numero_iterazione);
		 fprintf(ins_file,",");
		 fprintf(ins_file,"%i",temp->var->numero_blocco);
		 fprintf(ins_file,")");}
	}
	else if(temp->tipo_elemento==TRUE)
	        fprintf(ins_file,"TRUE");
	     else fprintf(ins_file,"FALSE");
}

/* Funzione che scrive su di un file le formule contenute nelle liste and, or e xor */

void scrivi_fml(FILE* sistema)
{   lista_xor* xor1;
	lista_and* and1;
    lista_or* or1;
	formula* temp;
	xor1=xor;
	or1=or;
	and1=and;
	/* Finch ci sono formule ripeti */
	while(xor1!=0)
	{ temp=xor1->formula_xor->parte_sinistra;
	  /* verifica se la parte sinistra  una variabile o una formula */
	  if(temp->succ==0)
	     scrivi_fml_lit(sistema,temp);
	  else
	  {  /* se si tratta di una formula questa sar di tipo xor */
	     fprintf(sistema,"XOR(");
         while(temp!=0)
	     {  scrivi_fml_lit(sistema,temp);
	        temp=temp->succ;
		    if(temp!=0)
		       fprintf(sistema,";");
         }
	     fprintf(sistema,")");
	  }
	  fprintf(sistema,"=");
	  temp=xor1->formula_xor->parte_destra;
	  /* verifica se la parte destra  una variabile o una formula */
	  if(temp->succ==0)
	  {  scrivi_fml_lit(sistema,temp);
	     fprintf(sistema,"\n"); } 
	  else
	  {  /* se si tratta di una formula questa sar di tipo xor */
	     fprintf(sistema,"XOR(");
         while(temp!=0)
	     {  scrivi_fml_lit(sistema,temp);
	        temp=temp->succ;
		    if(temp!=0)
               fprintf(sistema,";");
         }
	     fprintf(sistema,")\n");
	  }
	  xor1=xor1->next;
	}
	while(and1!=0)
	{ temp=and1->formula_and->parte_sinistra;
	  /* verifica se la parte sinistra  una variabile o una formula */
	  if(temp->succ==0)
	     scrivi_fml_lit(sistema,temp);
	  else
	  {  /* se si tratta di una formula questa sar di tipo and */
	     fprintf(sistema,"AND(");
         while(temp!=0)
	     {  scrivi_fml_lit(sistema,temp);
	        temp=temp->succ;
		    if(temp!=0)
		       fprintf(sistema,";");
         }
	     fprintf(sistema,")");
	  }
	  fprintf(sistema,"=");
	  temp=and1->formula_and->parte_destra;
	  /* verifica se la parte destra  una variabile o una formula */
	  if(temp->succ==0)
	  {  scrivi_fml_lit(sistema,temp);
	     fprintf(sistema,"\n"); }
	  else
	  {  /* se si tratta di una formula questa sar di tipo and */
	     fprintf(sistema,"AND(");
         while(temp!=0)
	     {  scrivi_fml_lit(sistema,temp);
	        temp=temp->succ;
		    if(temp!=0)
		       fprintf(sistema,";");
         }
	     fprintf(sistema,")\n");
	  }
	  and1=and1->next;
	}
	while(or1!=0)
	{ temp=or1->formula_or->parte_sinistra;
	  /* verifica se la parte sinistra  una variabile o una formula */
	  if(temp->succ==0)
	     scrivi_fml_lit(sistema,temp);
	  else
	  {  /* se si tratta di una formula questa sar di tipo or */
	     fprintf(sistema,"OR(");
         while(temp!=0)
	     {  scrivi_fml_lit(sistema,temp);
	        temp=temp->succ;
		    if(temp!=0)
		       fprintf(sistema,";");
         }
	     fprintf(sistema,")");
	  }
	  fprintf(sistema,"=");
	  temp=or1->formula_or->parte_destra;
	  /* verifica se la parte destra  una variabile o una formula */
	  if(temp->succ==0)
	  {  scrivi_fml_lit(sistema,temp);
	     fprintf(sistema,"\n"); }
	  else
	  {  /* se si tratta di una formula questa sar di tipo or */
	     fprintf(sistema,"OR(");
         while(temp!=0)
	     {  scrivi_fml_lit(sistema,temp);
	        temp=temp->succ;
		    if(temp!=0)
		       fprintf(sistema,";");
         }
	     fprintf(sistema,")\n");
	  }
	  or1=or1->next;
	}
}

