/* scrivi_smodel.c: modulo che costruisce i files contenenti le formule in
	           formato numerico da analizzare tramite algoritmi di
	           ricerca                                           */

#include <stdio.h>
#include <ctype.h>
#include "strutt.h"
#include "stampa_smodel.h"

extern lista_and* and;
extern lista_or* or;
extern lista_xor* xor;
extern lista_identita* id;

#define POS 1
#define NEG -1

#define CurrentBlock(A) (A->var->numero_blocco)

/* Funzione che scrive nel file ins_file l'elemento temp di una formula.  */


short samevar(formula* A, formula* B)
{
  return( A->tipo_elemento==VARIABILE && 
          A->tipo_elemento==B->tipo_elemento &&
          A->var->nome==B->var->nome &&
	  A->var->numero_blocco==B->var->numero_blocco &&
          A->var->posizione_bit==B->var->posizione_bit &&
          A->var->numero_iterazione==B->var->numero_iterazione);
}
          
short redefined(formula* fml, lista_identita* id)
{
  while(id!=0 && !samevar(fml,id->identita->parte_sinistra))
    id=id->next;
  return(id!=0);
}

short redefined(formula* fml, lista_and* and)
{
  while(and!=0 && !samevar(fml,and->formula_and->parte_sinistra))
    and=and->next;
  return(and!=0);
}

short redefined(formula* fml, lista_xor* xor)
{
  while(xor!=0 && !samevar(fml,xor->formula_xor->parte_sinistra))
    xor=xor->next;
  return(xor!=0);
}

short redefined(formula* fml, lista_or* or)
{
  while(or!=0 && !samevar(fml,or->formula_or->parte_sinistra))
    or=or->next;
  return(or!=0);
}


void scrivi_smodel_lit(FILE* sis,formula* fml,short segno)
{

  char var;

  if(fml->tipo_elemento==VARIABILE) {

    var = (char)tolower(fml->var->nome);

    if(!fml->var->negata)
      segno *= POS;
    else
      segno *= NEG;

    if (segno!=POS)
      fprintf(sis,"~");

    fprintf(sis,"%c(%ld,%ld",var,
                             fml->var->numero_blocco,
                             fml->var->posizione_bit);
    if (var!='k' && var!='c' && var!='p')
      fprintf(sis,",%ld",fml->var->numero_iterazione);
    fprintf(sis,")");
  }
  else {
    if(fml->tipo_elemento==TRUE)
      fprintf(sis,"T");
    else fprintf(sis,"F");
  }
}

/* Funzione che scrive su di un file le formule contenute nella lista id.
   Tale lista contiene le formule di tipo identit: es. A=B.              */                 
void scrivi_smodel_fml(FILE* sis,lista_identita* id)
{
  formula *A,*B;

  long number=0;

  while(id!=0) {

    A=id->identita->parte_sinistra;
    B=id->identita->parte_destra;

    if (A->var->negata) {
      scrivi_smodel_lit(sis,A,NEG);
      fprintf(sis," := ");
      scrivi_smodel_lit(sis,B,NEG);
    }
    else {
      scrivi_smodel_lit(sis,A,POS);
      fprintf(sis," := ");
      scrivi_smodel_lit(sis,B,POS);
    }
    fprintf(sis," ;\n");
    fflush(sis);

    id=id->next;
  }
}

/* Funzione che scrive su di un file le formule contenute nella lista and.
   Tale lista contiene le formule di tipo and: es. A=and(B,C).            */                 
void scrivi_smodel_fml(FILE* sis,lista_and* and)
{
  formula *A,*B;

  long number=0;

  while(and!=0) {

    A=and->formula_and->parte_sinistra;
    B=and->formula_and->parte_destra;

    if (A->tipo_elemento==VARIABILE && 
        !redefined(A,and->next)) {
      if (A->var->negata) {
	scrivi_smodel_lit(sis,A,NEG);
	fprintf(sis," := ~ ");
      }
      else {
	scrivi_smodel_lit(sis,A,POS);
	fprintf(sis," := ");
      }
    }
    else {
      ++number;
      fprintf(sis,"SET { vand(%ld,%ld) };\n ",CurrentBlock(A),number);
      fprintf(sis,"vand(%ld,%ld) := ",CurrentBlock(A),number);
      if (A->tipo_elemento==FALSE)
	fprintf(sis," ~ ");
      else if (A->tipo_elemento==VARIABILE) {
	scrivi_smodel_lit(sis,A,POS);
	fprintf(sis," == ");	
      }
    }
    fprintf(sis,"( ");
    while(B!=0) {
      scrivi_smodel_lit(sis,B,POS);
      if (B->succ!=0)
	fprintf(sis," & ");
      else
	fprintf(sis," )");
      B=B->succ;
    }
    fprintf(sis," ;\n");
    fflush(sis);

    and=and->next;
  }
}

/* Funzione che scrive su di un file le formule contenute nella lista or.
   Tale lista contiene le formule di tipo or: es. A=or(B,C).            */

void scrivi_smodel_fml(FILE* sis,lista_or* or)
{
  formula *A,*B;

  long number=0;

  while(or!=0) {

    A=or->formula_or->parte_sinistra;
    B=or->formula_or->parte_destra;

    if (A->tipo_elemento==VARIABILE && 
        !redefined(A,or->next) && !redefined(A,and)) {
      if (A->var->negata) {
	scrivi_smodel_lit(sis,A,NEG);
	fprintf(sis," := ~ ");
      }
      else {
	scrivi_smodel_lit(sis,A,POS);
	fprintf(sis," := ");
      }
    }
    else {
      ++number;
      fprintf(sis,"SET { vor(%ld,%ld) };\n ",CurrentBlock(A),number);
      fprintf(sis,"vor(%ld,%ld) := ",CurrentBlock(A),number);
      if (A->tipo_elemento==FALSE)
	fprintf(sis," ~ ");
      else if (A->tipo_elemento==VARIABILE) {
	scrivi_smodel_lit(sis,A,POS);
	fprintf(sis," == ");	
      }

    }
    fprintf(sis," ( ");
    while(B!=0) {
      scrivi_smodel_lit(sis,B,POS);
      if (B->succ!=0)
	fprintf(sis," | ");
      else
	fprintf(sis," )");
      B=B->succ;
    }
    fprintf(sis," ;\n");
    fflush(sis);

    or=or->next;
  }
}

/* Funzione che scrive su di un file le formule contenute nella lista xor.
   Tale lista contiene le formule di tipo xor: es. A=xor(B,C).            */                 
void scrivi_smodel_fml(FILE* sis,lista_xor* xor)
{
  formula *A,*B,*C;
  long number=0;

  while(xor!=0) {

    A=xor->formula_xor->parte_sinistra;
    B=xor->formula_xor->parte_destra;
    C=B->succ;

    if (A->tipo_elemento==VARIABILE && 
        !redefined(A,xor->next) && !redefined(A,or) && !redefined(A,and)) {
      if (A->var->negata) {
	scrivi_smodel_lit(sis,A,NEG);
	fprintf(sis," := ~ ");
      }
      else {
	scrivi_smodel_lit(sis,A,POS);
	fprintf(sis," := ");
      }
    }
    else {
      ++number;
      fprintf(sis,"SET { vxor(%ld,%ld) };\n ",CurrentBlock(A),number);
      fprintf(sis,"vxor(%ld,%ld) := ",CurrentBlock(A),number);
      if (A->tipo_elemento==FALSE)
	fprintf(sis," ~ ");
      else if (A->tipo_elemento==VARIABILE) {
	scrivi_smodel_lit(sis,A,POS);
	fprintf(sis," == ");	
      }
    }
    fprintf(sis," ( ");
    scrivi_smodel_lit(sis,B,POS);
    fprintf(sis," ^ ");
    scrivi_smodel_lit(sis,C,POS);
    fprintf(sis," )");
    fprintf(sis," ;\n");
    fflush(sis);

    xor=xor->next;
  }
}

void scrivi_smodel(FILE* sis)
{
//  scrivi_smodel_fml(sis,id);
  scrivi_smodel_fml(sis,and);
  scrivi_smodel_fml(sis,or);
  scrivi_smodel_fml(sis,xor);
}



