/*  valuprop.c: modulo che realizza il valutatore proposizionale */

#include "strutt.h"
#include "valuprop.h"
#include "minimiz.h"
#include "comune.h"
#include "propagID.h"
#include <stdio.h>

extern lista_xor* xor;
extern lista_and* and;
extern lista_or* or;
extern lista_identita* identity;
extern lista_identita* ultimo;

/*************************** Prototipi funzioni **************************/
void valuta_xor(int&);
void valuta_and(int&);
void valuta_or(int&);
int xor_caso1(int&,definizione*);
int xor_caso2(int&,definizione*);
int xor_caso3(int&,definizione*);
int xor_caso4(int&,definizione*);
int xor_caso5(int&,definizione*);
int xor_caso6(int&,definizione*);
int xor_caso7(int&,definizione*);
int xor_caso8(int&,definizione*);
int and_caso1(definizione*);
int and_caso2(definizione*);
int and_caso3(definizione*);
int and_caso4(definizione*);
void and_caso5(formula*);
int or_caso1(definizione*);
int or_caso2(definizione*);
int or_caso3(definizione*);
int or_caso4(definizione*);
void or_caso5(formula*);
void insID(elemento, formula*);
void agg_lista_identita(definizione*);
/************************************************************************/

void valutatore_proposizionale(int& cambiato)
{	valuta_xor(cambiato);
	valuta_and(cambiato);
	valuta_or(cambiato);
}

/* Funzione che effettua la valutazione proposizionale inerente le xor */
void valuta_xor(int& cambiato)
{
  lista_xor* scorri_xor;
  lista_xor* precedente;
  scorri_xor=xor;
  int camb;
  while(scorri_xor!=0) {  
    camb=xor_caso1(cambiato,scorri_xor->formula_xor);
    if(camb) {
      scorri_xor=scorri_xor->next;
      continue;
    }
    camb=xor_caso2(cambiato,scorri_xor->formula_xor);
    if(camb) {
      scorri_xor=scorri_xor->next;
      continue;
    }
    camb=xor_caso3(cambiato,scorri_xor->formula_xor);
    if(camb) {
      scorri_xor=scorri_xor->next;
      continue;
    }
    camb=xor_caso4(cambiato,scorri_xor->formula_xor);
    if(camb)
      {  scorri_xor=scorri_xor->next;
      continue;
      }
    camb=xor_caso5(cambiato,scorri_xor->formula_xor);
    if(camb)
      {  scorri_xor=scorri_xor->next;
      continue;
      }
    camb=xor_caso6(cambiato,scorri_xor->formula_xor);
    if(camb)
      {  scorri_xor=scorri_xor->next;
      continue;
      }
    camb=xor_caso7(cambiato,scorri_xor->formula_xor);
    if(camb)
      {  scorri_xor=scorri_xor->next;
      continue;
      }
    xor_caso8(cambiato,scorri_xor->formula_xor);
    scorri_xor=scorri_xor->next;
  }
  scorri_xor=xor;
  precedente=xor;
  while(scorri_xor!=0) { 
    if(scorri_xor->formula_xor->parte_destra->succ==0) {
      /* se parte destra e' composta da una sola variabile allora ho
	 un'identita' che devo aggiungere alla lista delle identita' */
      aggiungi_lista_identita(scorri_xor->formula_xor);
      if(scorri_xor!=precedente)
	/* se quello attuale non e' il primo elemento della lista,
	   allora per eliminare l'identita' dalla lista
	   precedente->next puntera' allo stesso elemento cui puntera'
	   scorri alla prossima iterazione                          */       
	precedente->next=scorri_xor->next; 
      else {
	/* altrimenti precedente puntera' allo stesso elemento cui
	   puntera' scorri nella prossima iterazione e dalla lista che
	   stiamo esaminando verra' eliminato il primo elemento     */
	precedente=scorri_xor->next;
	xor=scorri_xor->next;
	}
      }
    /* in caso contrario si dovra' solo avanzare il puntatore che
       punta all'elemento precedente                               */
    else precedente=scorri_xor;
    /* in ogni caso si passa ad analizzare l'elemento successivo   */
    scorri_xor=scorri_xor->next;
    }
}

/* Funzione che gestisce il caso false=BxorC, sostituendo la formula con
   B=C.                                                                  */
int xor_caso1(int& cambiato,definizione* formu)
{   formula* scorri;
    variabile* nuova_parte;
    if(formu->parte_sinistra->tipo_elemento!=FALSE)
	   return 0;
    scorri=formu->parte_destra;
    formu->parte_sinistra->tipo_elemento=scorri->tipo_elemento;
    if(scorri->tipo_elemento!=VARIABILE)
	formu->parte_sinistra->var=0;
    else
    { nuova_parte=new variabile;
      copia_variabile(nuova_parte,scorri);
      formu->parte_sinistra->var=nuova_parte;
    }
    formu->parte_destra=scorri->succ;
    cambiato=1;
    return 1;
}

/* Funzione che gestisce il caso true=BxorC, sostituendo la formula con
   B=notC.                                                              */
int xor_caso2(int& cambiato,definizione* formu)
{   formula* scorri;
    variabile* nuova_parte;
    if(formu->parte_sinistra->tipo_elemento!=TRUE)
       return 0;
    scorri=formu->parte_destra;
    formu->parte_sinistra->tipo_elemento=scorri->tipo_elemento;
    if(scorri->tipo_elemento!=VARIABILE)
	formu->parte_sinistra->var=0;
    else
    { nuova_parte=new variabile;
      copia_variabile(nuova_parte,scorri);
      formu->parte_sinistra->var=nuova_parte;
    }
    formu->parte_destra=scorri->succ;
    if(formu->parte_destra->tipo_elemento==VARIABILE)
	if(formu->parte_destra->var->negata==0)
	   formu->parte_destra->var->negata=1;
	else formu->parte_destra->var->negata=0;
    else if(formu->parte_destra->tipo_elemento==TRUE)
   	    formu->parte_destra->tipo_elemento=FALSE;
	 else formu->parte_destra->tipo_elemento=TRUE;
    cambiato=1;
    return 1;
}

/* Funzione che gestisce il caso A=BxorA, ed il caso (notA)=Bxor(notA),
   sostituendo la formula con B=0.                                      */
int xor_caso3(int& cambiato, definizione* formu)
{	formula* elem;
	int trovato=0;
	elem=contenuto(formu->parte_sinistra,formu->parte_destra,trovato);
	if(trovato)
	{  formu->parte_sinistra->tipo_elemento=FALSE;
	   if(elem->succ==0)
	      formu->parte_destra->succ=0;
	   else formu->parte_destra=elem->succ;
	   cambiato=1;
	   return 1;
	}
	return 0;
}

/* Funzione che gestisce il caso A=Bxor(notA), ed il caso (notA)=BxorA,
   sostituendo la formula con B=1.                                      */
int xor_caso4(int& cambiato, definizione* formu)
{	formula* elem;
	int trovato=0;
	formula* var_negata;
	var_negata=new formula;
	var_negata->var=new variabile;
	var_negata->tipo_elemento=VARIABILE;
	var_negata->succ=0;
	copia_var(var_negata,formu->parte_sinistra);
	if(formu->parte_sinistra->var->negata==0)
	   var_negata->var->negata=1;
        else var_negata->var->negata=0;
	elem=contenuto(var_negata,formu->parte_destra,trovato);
	if(trovato)
	{  formu->parte_sinistra->tipo_elemento=TRUE;
	   if(elem->succ==0)
	      formu->parte_destra->succ=0;
	   else formu->parte_destra=elem->succ;
	   cambiato=1;
	   return 1;
	}
	return 0;
}

/* Funzione che gestisce il caso A=BxorFALSE, sostituendo la formula con
   A=B.                                                                 */
int xor_caso5(int& cambiato, definizione* formu)
{	formula* scorri;
	formula* precedente;
	scorri=formu->parte_destra;
        precedente=formu->parte_destra;
	while(scorri!=0)
	{  if(scorri->tipo_elemento==FALSE)
	   {  if(scorri!=precedente)
		     precedente->succ=scorri->succ;
	      else
	         formu->parte_destra=scorri->succ;
	      cambiato=1;
	      return 1;
	   }
	   scorri=scorri->succ;
	}
	return 0;
}

/* Funzione che gestisce il caso A=BxorTRUE, sostituendo la formula con
   A=notB.                                                              */
int xor_caso6(int& cambiato, definizione* formu)
{	formula* scorri;
	formula* precedente;
	scorri=formu->parte_destra;
        precedente=formu->parte_destra;
	while(scorri!=0)
	{  if(scorri->tipo_elemento==TRUE)
	   {  if(scorri!=precedente)
		     precedente->succ=scorri->succ;
	      else
	         formu->parte_destra=scorri->succ;
	      if(formu->parte_sinistra->var->negata==0)
	         formu->parte_sinistra->var->negata=1;
	      else formu->parte_sinistra->var->negata=0;
	      cambiato=1;
	      return 1;
	   }
	   scorri=scorri->succ;
	}
	return 0;
}

/* Funzione che gestisce il caso A=BxorB, sostituendo la formula con
   A=0.                                                              */
int xor_caso7(int& cambiato, definizione* formu)
{       formula* form1;
	variabile* var1;
        variabile* var2;
	form1=formu->parte_destra;
	var1=form1->var;
        var2=form1->succ->var;
	if(uguali(form1,form1->succ)&&
	  (var1->negata==var2->negata))
	{  formu->parte_destra->tipo_elemento=FALSE;
	   formu->parte_destra->succ=0;
	   cambiato=1;
	   return 1;
	}
	return 0;
}

/* Funzione che gestisce il caso A=Bxor(notB), sostituendo la formula con
   A=1.                                                                  */
int xor_caso8(int& cambiato, definizione* formu)
{       formula* form1;
	variabile* var1;
        variabile* var2;
	form1=formu->parte_destra;
	var1=form1->var;
        var2=form1->succ->var;
	if(uguali(form1,form1->succ)&&
	  (var1->negata!=var2->negata))
	{  formu->parte_destra->tipo_elemento=TRUE;
	   formu->parte_destra->succ=0;
	   cambiato=1;
	   return 1;
	}
	return 0;
}

/* Funzione che effettua la valutazione proposizionale delle formule AND */
void valuta_and(int& cambiato)
{	lista_and* attuale;
	lista_and* prece;
        lista_and* scorri_and;
	attuale=and;
        prece=and;
        int camb;
	while(attuale!=0)
	{  camb=and_caso1(attuale->formula_and);
	   if(camb)
	   {  if(attuale!=prece)
	         prece=prece->next;
              attuale=attuale->next;
	      cambiato=1;
	      continue;
	   }
	   camb=and_caso2(attuale->formula_and);
	   if(camb)
	   {  if(attuale!=prece)
	         prece=prece->next;
              attuale=attuale->next;
	      cambiato=1;
	      continue;
	   }
	   camb=and_caso3(attuale->formula_and);
	   if(camb)
	   {  if(attuale!=prece)
	         prece=prece->next;
              attuale=attuale->next;
	      cambiato=1;
	      continue;
	   }
	   camb=and_caso4(attuale->formula_and);
	   if(camb)
	   {  if(attuale!=prece)
	         prece=prece->next;
              attuale=attuale->next;
	      cambiato=1;
	      continue;
	   }
           if(attuale->formula_and->parte_sinistra->tipo_elemento==TRUE)
	   {  and_caso5(attuale->formula_and->parte_destra);
	      if(attuale!=prece)
                 prece->next=attuale->next;
              else
     	      {  prece=prece->next;
                 and=and->next;
              }
              camb=1;
	    }
	    else
	    {  if(attuale!=prece)
	          prece=prece->next;
	       camb=0;
	    }
	    if(camb)
               cambiato=1;
	    attuale=attuale->next;
	}
	scorri_and=and;
        prece=and;
	while(scorri_and!=0)
	{ if(scorri_and->formula_and->parte_destra->succ==0)
	  /* se parte destra e' composta da una sola variabile allora ho
	     un'identita' che devo aggiungere alla lista delle identita'*/
	  { aggiungi_lista_identita(scorri_and->formula_and);
            if(scorri_and!=prece)
	      /* se quello attuale non e' il primo elemento della lista,
	         allora per eliminare l'identita' dalla lista
	         precedente->next puntera' allo stesso elemento cui puntera'
	         scorri alla prossima iterazione                          */       
		     prece->next=scorri_and->next; 
	    else
	      /* altrimenti precedente puntera' allo stesso elemento cui
	         puntera' scorri nella prossima iterazione e dalla lista che
	         stiamo esaminando verra' eliminato il primo elemento     */
	    { prece=scorri_and->next;
	      and=scorri_and->next;
	    }
	  }
	  /* in caso contrario si dovra' solo avanzare il puntatore che
	     punta all'elemento precedente                               */
	  else prece=scorri_and;
	  /* in ogni caso si passa ad analizzare l'elemento successivo   */
	  scorri_and=scorri_and->next;
	}
}

/* Funzione che gestisce il caso A=BandFALSE, sostituendo tale formula con
   A=FALSE.                                                               */
int and_caso1(definizione* attuale)
{	formula* scorri;
        scorri=attuale->parte_destra;
 	while(scorri!=0)
	{  if(scorri->tipo_elemento==FALSE)
	   {  attuale->parte_destra->tipo_elemento=FALSE;
	      attuale->parte_destra->succ=0; 
	      return 1;
	   }
	   scorri=scorri->succ;
	}
	return 0;
}

/* Funzione che gestisce il caso A=Band(notB), sostituendo tale formula
   con A=FALSE.                                                         */
int and_caso2(definizione* attuale)
{	formula* scorri;
	formula* var_attuale;
	var_attuale=attuale->parte_destra;
	while(var_attuale!=0)
	{ scorri=var_attuale->succ;
          if(var_attuale->tipo_elemento==VARIABILE)
	   while(scorri!=0)
	   {  if(uguali(scorri,var_attuale)&&
   	        (scorri->var->negata!=var_attuale->var->negata))
	      {  attuale->parte_destra->tipo_elemento=FALSE;
	         attuale->parte_destra->succ=0;
	         return 1;
	      }
	      scorri=scorri->succ;
	   }
	  var_attuale=var_attuale->succ;
        }
	return 0;
}

/* Funzione che gestisce il caso A=BandB, sostituendo tale formula
   con A=B.                                                         */
int and_caso3(definizione* attuale)
{	formula* scorri;
	formula* var_attuale;
	formula* prec;
        int trovato=0;
	var_attuale=attuale->parte_destra;
        prec=attuale->parte_destra;
	while(var_attuale!=0)
	{ scorri=var_attuale->succ;
	  if(var_attuale->tipo_elemento==VARIABILE)
	   while(scorri!=0)
	   {  if(uguali(scorri,var_attuale)&&
	        (scorri->var->negata==var_attuale->var->negata)) 
	      {  prec->succ=scorri->succ;
	         trovato=1;
	      }
              else prec=prec->succ;
	      scorri=scorri->succ;
	   }
	  prec=var_attuale->succ;
	  var_attuale=var_attuale->succ;
        }
	return trovato;
}

/* Funzione che gestisce il caso A=BandTRUE, sostituendo tale formula
   con A=B.                                                           */
int and_caso4(definizione* attuale)
{	formula* scorri;
	formula* prec;
	int trovato=0;
	scorri=attuale->parte_destra;
	prec=attuale->parte_destra;
	while(scorri!=0)
	{   if((scorri->tipo_elemento==TRUE))		 
    	    { if((scorri->succ==0)&&(attuale->parte_destra==scorri))
			return trovato;
	      if(scorri==prec)
	      {  attuale->parte_destra=attuale->parte_destra->succ;
	         prec=prec->succ;
              }
	      else prec->succ=scorri->succ;
	      trovato=1;
	}
        else if(prec!=scorri) prec=prec->succ;
	scorri=scorri->succ;
	}	
	return trovato;
}

/* Funzione che gestisce il caso TRUE=BandA , sostituendo tale
   formula con A=TRUE e B=TRUE.                                */
void and_caso5(formula* destra)
{   while(destra!=0)
    {  insID(TRUE,destra);
       destra=destra->succ;
    }   
}


/* Funzione che effettua la valutazione proposizionale delle formule OR */
void valuta_or(int& cambiato)
{	lista_or* attuale;
	lista_or* prece;
	lista_or* scorri_or;
	attuale=or;
	prece=or;
        int camb;
	while(attuale!=0)
	{  camb=or_caso1(attuale->formula_or);
	    if(camb)
	    {  if(attuale!=prece)
		      prece=prece->next;
               attuale=attuale->next;
	       cambiato=1;
	       continue;
	    }
	    camb=or_caso2(attuale->formula_or);
	    if(camb)
	    { if(attuale!=prece)
	         prece=prece->next;
              attuale=attuale->next;
	      cambiato=1;
	      continue;
	    }
	    camb=or_caso3(attuale->formula_or);
	    if(camb)
	    {  if(attuale!=prece)
		      prece=prece->next;
               attuale=attuale->next;
	       cambiato=1;
	       continue;
	    }
	    camb=or_caso4(attuale->formula_or);
	    if(camb)
	    {  if(attuale!=prece)
		      prece=prece->next;
               attuale=attuale->next;
	       cambiato=1;
	       continue;
	    }
	    if(attuale->formula_or->parte_sinistra->tipo_elemento==FALSE)
	    {  or_caso5(attuale->formula_or->parte_destra);
	       if(attuale!=prece)
                  prece->next=attuale->next;
               else
     	       {  prece=prece->next;               	
                  or=or->next;
               }
               camb=1;
	    }
	    else
	    {  if(attuale!=prece)
		      prece=prece->next;
	       camb=0;
	    }
	    if(camb)
	       cambiato=1;
	    attuale=attuale->next;
	}
	scorri_or=or;
	prece=or;
	while(scorri_or!=0)
	{ if(scorri_or->formula_or->parte_destra->succ==0)
	  /* se parte destra e' composta da una sola variabile allora ho
	     un'identita' che devo aggiungere alla lista delle identita' */
	  {  aggiungi_lista_identita(scorri_or->formula_or);
	     if(scorri_or!=prece)
	     /* se quello attuale non e' il primo elemento della lista,
		    allora per eliminare l'identita' dalla lista
		    precedente->next puntera' allo stesso elemento cui puntera'
		    scorri alla prossima iterazione                          */       
		    prece->next=scorri_or->next;
	     else
	     /* altrimenti precedente puntera' allo stesso elemento cui
	    	puntera' scorri nella prossima iterazione e dalla lista che
		    stiamo esaminandoo verra' eliminato il primo elemento     */
	     {	prece=scorri_or->next;
	        or=scorri_or->next;
	     }
	  }
	  /* in caso contrario si dovra' solo avanzare il puntatore che
	     punta all'elemento precedente                               */
	  else prece=scorri_or;
	  /* in ogni caso si passa ad analizzare l'elemento successivo   */
	  scorri_or=scorri_or->next;
	}
}

/* Funzione che gestisce il caso A=BorTRUE, sostituendo tale formula con
   A=TRUE.                                                               */
int or_caso1(definizione* attuale)
{	formula* scorri;
        scorri=attuale->parte_destra;
	while(scorri!=0)
	{  if(scorri->tipo_elemento==TRUE)
	   {  attuale->parte_destra->tipo_elemento=TRUE;
	      attuale->parte_destra->succ=0;
	      return 1;
	   }
	   scorri=scorri->succ;
	}
	return 0;
}

/* Funzione che gestisce il caso A=Bor(notB), sostituendo tale formula
   con A=TRUE.                                                         */
int or_caso2(definizione* attuale)
{	formula* scorri;
	formula* var_attuale;
	var_attuale=attuale->parte_destra;
	while(var_attuale!=0)
	{ scorri=var_attuale->succ;
          if(var_attuale->tipo_elemento==VARIABILE)
	   while(scorri!=0)
	   {  if(uguali(scorri,var_attuale)&&
   	        (scorri->var->negata!=var_attuale->var->negata))
	      {  attuale->parte_destra->tipo_elemento=TRUE;
	         attuale->parte_destra->succ=0;
	         return 1;
	      }
	      scorri=scorri->succ;
	   }
	  var_attuale=var_attuale->succ;
    }
	return 0;
}

/* Funzione che gestisce il caso A=BorB, sostituendo tale formula
   con A=B.                                                         */
int or_caso3(definizione* attuale)
{	formula* scorri;
	formula* var_attuale;
	formula* prec;
        int trovato=0;
	var_attuale=attuale->parte_destra;
        prec=attuale->parte_destra;
	while(var_attuale!=0)
	{ scorri=var_attuale->succ;
	  if(var_attuale->tipo_elemento==VARIABILE)
	   while(scorri!=0)
	   {  if(uguali(scorri,var_attuale)&&
	        (scorri->var->negata==var_attuale->var->negata)) 
	      {  prec->succ=scorri->succ;
	         trovato=1;
	      }
              else prec=prec->succ;
	      scorri=scorri->succ;
	   }
	  prec=var_attuale->succ;
	  var_attuale=var_attuale->succ;
        }
	return trovato;
}

/* Funzione che gestisce il caso A=BorFALSE, sostituendo tale formula
   con A=B.                                                           */
int or_caso4(definizione* attuale)
{	formula* scorri;
	formula* prec;
	int trovato=0;
	scorri=attuale->parte_destra;
	prec=attuale->parte_destra;
	while(scorri!=0)
	{   if((scorri->tipo_elemento==FALSE))		 
   	    {  if((scorri->succ==0)&&(attuale->parte_destra==scorri))
			return trovato;
	       if(scorri==prec)
	       {  attuale->parte_destra=attuale->parte_destra->succ;
	          prec=prec->succ;
               }
	       else prec->succ=scorri->succ;
	       trovato=1;
	    }
	    else if(prec!=scorri) prec=prec->succ;
	    scorri=scorri->succ;
	}	
	return trovato;
}

/* Funzione che gestisce i casi FALSE=BorA e A=AorB, sostituendo tali
   formule con A=FALSE e B=FALSE (nel secondo caso invece si ha B=FALSE). */
void or_caso5(formula* destra)
{   while(destra!=0)
	{  insID(FALSE, destra);
           destra=destra->succ;
	}   
}


void insID(elemento x, formula* destra)
{	   definizione* def;
	   def=new definizione;
	   def->parte_sinistra=new formula;
	   def->parte_destra=new formula;
           def->parte_sinistra->tipo_elemento=x;
	   def->parte_sinistra->var=0;
	   def->parte_sinistra->succ=0;
	   def->parte_destra->tipo_elemento=destra->tipo_elemento;
	   if(destra->tipo_elemento!=VARIABILE)
	      def->parte_destra->var=0;
	   else
           {  def->parte_destra->var=new variabile;
              copia(def->parte_destra,destra);
	   }
	   def->parte_destra->succ=0;
	   agg_lista_identita(def);
}

/* Se def e' un'identita' la aggiunge alla lista delle identita' */
void agg_lista_identita(definizione* def)
{   lista_identita* id;
    id=new lista_identita;
    id->identita=new definizione;
    id->identita=def;
    id->next=0;
    if(ultimo!=0)
       ultimo->next=id;
    else
       identity=id;
    ultimo=id;
}
