/* verifica.c : modulo che realizza il verificatore */

#include "verifica.h"
#include "modif_id.h"
#include "valuprop.h"
#include "propagID.h"
#include "strutt.h"
#include "minimiz.h"
#include "confron.h"
#include "garbage.h"
#include <stdio.h>
#include <stdlib.h>

extern lista_identita* identity;
extern lista_identita* ultimo;
extern lista_or* or;
extern lista_and* and;
extern lista_xor* xor;
extern formula* bit_chiave[64];
extern lista_identita* id;

/****************************** Prototipi funzioni ***********************/
void inserisci_bit_chiave(int*,int);
void in_lista_identita(definizione*);
/*************************************************************************/

/* Funzione che permette di verificare la correttezza del circuito generato.
   Si procede inserendo i bit associati alla chiave costruendo delle identita',
   e poi, dopo aver propagato tali identita', si procede con una serie di cicli: 
   valutazione proposizionale, aggiustamento lista identita', propagazione 
   identita'.                                                                    */
void verificatore(int* key, int num_bl_key)
{   int cambiato=1;
	inserisci_bit_chiave(key,num_bl_key);
	while(cambiato)
	{  cambiato=0;
	   normalizza_listaID();
       	   propaga_in_listaID();
	   propaga_identita();
	   id=identity;
	   garbage(1);
	   identity=0;
	   ultimo=0;
	   valutatore_proposizionale(cambiato);
	}
}

/* Funzione che inserisce i bit della chiave nel sistema di prova */
void inserisci_bit_chiave(int* key, int num_bl_key)
{	int i;
	definizione* id;
	for(i=0;i<64;i++)
	{  id=new definizione;
	   id->parte_destra=new formula;
	   id->parte_sinistra=new formula;
	   id->parte_destra->var=new variabile;
	   id->parte_sinistra->succ=0;
	   id->parte_sinistra->var=0;
	   if(key[i]==0)
	      id->parte_sinistra->tipo_elemento=FALSE;
	   else id->parte_sinistra->tipo_elemento=TRUE;
	   if(bit_chiave[i]==0)
	   {  id->parte_destra->tipo_elemento=VARIABILE;
	      id->parte_destra->succ=0;
	      id->parte_destra->var->nome='K';
	      id->parte_destra->var->posizione_bit=i+1;
	      id->parte_destra->var->numero_iterazione=0;
	      id->parte_destra->var->numero_blocco=num_bl_key;
	      id->parte_destra->var->negata=0;
	   }
       else
	   {  id->parte_destra->tipo_elemento=bit_chiave[i]->tipo_elemento;
	      id->parte_destra->succ=0;
	      id->parte_destra->var->nome=bit_chiave[i]->var->nome;
	      id->parte_destra->var->posizione_bit=bit_chiave[i]->var->posizione_bit;
	      id->parte_destra->var->numero_iterazione=bit_chiave[i]->var->numero_iterazione;
	      id->parte_destra->var->numero_blocco=bit_chiave[i]->var->numero_blocco;
	      id->parte_destra->var->negata=bit_chiave[i]->var->negata;
	   }
	   in_lista_identita(id);
	}	
}

/* Se def e' un'identit la aggiunge alla lista delle identita' */
void in_lista_identita(definizione* def)
{   lista_identita* id;
	id=new lista_identita;
    id->identita=def;
	id->next=0;
	if(ultimo!=0)
	   ultimo->next=id;
	else
	   identity=id;
	ultimo=id;
}
