/**CFile***********************************************************************

  FileName    [simError.c]

  PackageName [sim]

  Synopsis    [Error handling]

  Description [Internal procedures included in this module:
		<ul>
		<li> <b>SimDllThrow()</b> raises a SIG_USR1 to signal
		     that something was wrong
		</ul>]
		
  SeeAlso     []

  Author      [Armando Tacchella Davide Zambonin]

  Copyright   [Copyright (c) 2000 by DIST - Universita' di Genova, Italia.  
               All Rights Reserved. This software is for educational
               purposes only.  Permission is given to academic
               institutions to use, copy, and modify this software and
               its documentation provided that this introductory
               message is not removed, that this software and its
               documentation is used for the institutions' internal
               research and educational purposes, and that no monies
               are exchanged. No guarantee is expressed or implied by
               the distribution of this code.  Permission to
               distribute this code is given to ITC-IRST,
               provided that the code is distributed as is.
               Send bug-reports and/or questions to: sim@mrg.dist.unige.it]

  Revision    [v. 1beta]

******************************************************************************/


#include "simInt.h"


/*---------------------------------------------------------------------------*/
/* Constant declarations                                                     */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Stucture declarations                                                     */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Type declarations                                                         */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Variable declarations                                                     */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Macro declarations                                                        */
/*---------------------------------------------------------------------------*/


/**AutomaticStart*************************************************************/

/*---------------------------------------------------------------------------*/
/* Static function prototypes                                                */
/*---------------------------------------------------------------------------*/


/**AutomaticEnd***************************************************************/


/*---------------------------------------------------------------------------*/
/* Definition of internal functions                                          */
/*---------------------------------------------------------------------------*/


/**Function********************************************************************

  Synopsis    [Prompts an error to the user and raises a SIGUSR1.]

  Description [Takes an error type and the error location in the program
               Prompts the user on stderr and teminates raising the user 
	       defined signal SIGUSR1.] 

  SideEffects [none]

  SeeAlso     []

******************************************************************************/
void
SimDllThrow(
  Sim_ErrKind_c   errKind,
  char          * place)
{
  
  /* Establish what kind of error occurred. */
  switch (errKind) {
  case SIM_NO_ERROR:
    return;
  case SIM_INTERNAL_ERROR: 
    fprintf(stderr, "SIM_INTERNAL_ERROR ");
    break;
  case SIM_IO_ERROR: 
    fprintf(stderr, "SIM_IO_ERROR ");
    break;
  case SIM_MEMORY_ERROR:
    fprintf(stderr, "SIM_MEMORY_OUT ");
    break;
  case SIM_VERIFY_ERROR:
    fprintf(stderr, "SIM_VERIFY_FAILED ");
    break;
  }
  
  /* Say the place and the cause of the error. */
  fprintf(stderr, "in %s\nGiving up.\n", place);
  
  /* Update the information about the failure. */
  SimFailCond = errKind;

#ifdef HAVE_SIGNAL_H
  /* Raise the signal. */
  raise(SIGUSR1);
#else
  /* Abort. */
  exit((int)errKind);
#endif
  
} /* End of SimDllThrow. */


