/**CFile***********************************************************************

  FileName    [simProp.c]

  PackageName [sim]

  Synopsis    [Primitives for propositions]

  Description [Internal procedures included in this module:
		<ul>
		<li> <b>SimPropInit()</b> clause construtor
		<li> <b>SimPropClear()</b> clause destructor
		</ul>]
		
  SeeAlso     [sim.h]

  Author      [Armando Tacchella]

  Copyright   [Copyright (c) 2000 by DIST - Universita' di Genova, Italia.  
               All Rights Reserved. This software is for educational
               purposes only.  Permission is given to academic
               institutions to use, copy, and modify this software and
               its documentation provided that this introductory
               message is not removed, that this software and its
               documentation is used for the institutions' internal
               research and educational purposes, and that no monies
               are exchanged. No guarantee is expressed or implied by
               the distribution of this code.  Permission to
               distribute this code is given to ITC-IRST,
               provided that the code is distributed as is.
               Send bug-reports and/or questions to: sim@mrg.dist.unige.it]

  Revision    [v. 1beta]

******************************************************************************/


#include "simInt.h"


/*---------------------------------------------------------------------------*/
/* Constant declarations                                                     */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Stucture declarations                                                     */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Type declarations                                                         */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Variable declarations                                                     */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Macro declarations                                                        */
/*---------------------------------------------------------------------------*/


/**AutomaticStart*************************************************************/

/*---------------------------------------------------------------------------*/
/* Static function prototypes                                                */
/*---------------------------------------------------------------------------*/


/**AutomaticEnd***************************************************************/


/*---------------------------------------------------------------------------*/
/* Definition of internal functions                                          */
/*---------------------------------------------------------------------------*/


/**Function********************************************************************

  Synopsis    [Initializes a proposition.]

  Description [Initializes a proposition.]

  SideEffects [none]

  SeeAlso     []

******************************************************************************/
SimProp_t*
SimPropInit(
  int   prop,
  short litSize)		  
{
  
  SimProp_t * p = (SimProp_t*)malloc(sizeof(SimProp_t));
  SimDllMemCheck(p, "SimPropInit");

  /* Initialize data fields. */
  p -> prop = prop;
  p -> teta = SIM_DC;
  p -> backProps = -1;
  p -> backModelProps = -1;

  /* Initialize 0-terminated list of clauses references. */
  VinitReserve0(p -> posLits, litSize);
  SimDllMemCheck(V(p -> posLits), "SimPropInit");
  VinitReserve0(p -> negLits, litSize);
  SimDllMemCheck(V(p -> negLits), "SimPropInit");

#ifdef BACKJUMPING
  p -> reason = 0;
#endif

  return p;

} /* End of SimPropInit. */


/**Function********************************************************************

  Synopsis    [Clears a proposition.]

  Description [Clears a proposition.]

  SideEffects [none]

  SeeAlso     []

******************************************************************************/
void 
SimPropClear(
  SimProp_t * p)
{
  
  Vclear(p -> posLits);
  Vclear(p -> negLits);
  free(p);

  return;

}



