#include "lip.h" 


/* La seguente funzione codifica il risultato dell'operazione (f*f*f)mod n nel
   formalismo di Lparse.
*/

void codifica_m(verylong x, long bit)
{ 
  long i;
  for(i=0;i<bit-1;i++)
    if(!zbit(x,i))
       printf("~m_%d &\n",i);
    else
       printf("m_%d &\n",i);
  if(!zbit(x,bit-1))
       printf("~m_%d \n",i);
    else
       printf("m_%d \n",i);
  printf("\n");
  return;

}





/* La seguente funzione codifica il complemento a due del modulo "n"
   dell'operazione (f*f*f)mod n nel formalismo di Lparse.
*/

void codifica_n(long bit, verylong complemento)
{
  long i;
  for(i=0;i<=bit;i++)
    if(zbit(complemento,i))
       printf("e%d &\n",i);
    else printf("~e%d &\n",i);
  
  return; 
}




/* La seguente funzione codifica il risultato di "1/n" troncato al bit
   2*b-esimo(con b numero di bit necessari alla rappresentazione di "n")
   dell'operazione (f*f*f)mod n nel formalismo di Lparse.
*/

void codifica_t(verylong n, long bit, verylong complemento)
{
  long d,fine,i,j;
  verylong somma=0,carry=0,somma1=0,carry1=0,resto=0;
  verylong aux=0, t=0;
  
 
  zone(&resto);
  zlshift(resto,1,&resto);
  
  for(i=0;i<2*bit;i++)
  {  
    d=zcompare(n,resto);
    
    // se il divisore della divisione 1/n e' maggiore del resto parziale,
    // quest'ultimo viene moltiplicato per 10 e si aggiunge la cifra 0 al
    // quoto; altrimenti al quoto si aggiunge la cifra 1 e si calcola il nuovo
    // resto.

    if(d==1) 
      zlshift(resto,1,&resto);
       
    else
     { zsetbit(&t,i);
       carry=0;
       somma=0;
       aux=0;
        
       // sommatore carry-save : serve per il calcolo del nuovo resto, dato
       // dalla somma del resto precedente e del complemento a due di n,
       // memorizzato in e.
 
       for(j=0;j<=bit;j++)
        { // inizializzazione del sommatore
          if(zbit(resto,j) ^ zbit(complemento,j))
                  zsetbit(&somma,j);
          if(zbit(resto,j) && zbit(complemento,j))
                  zsetbit(&carry,j);
              
        };
       
   
       fine=1;
       while(fine!=0)           // finche' il carry non sara' nullo, verranno
                                // calcolati un nuovo carry ed una nuova somma 
        { 
          somma1=0;
          carry1=0;
          zlshift(carry,1,&carry);
          zcopy(somma,&aux); 
          for(j=0;j<=bit;j++)
             if(zbit(somma,j) ^ zbit(carry,j))
                 zsetbit(&somma1,j);  
          for(j=0;j<=bit;j++)
             if(zbit(aux,j) && zbit(carry,j))
             zsetbit(&carry1,j);
          zcopy(somma1,&somma);
          zcopy(carry1,&carry);
          fine=0;
          for(j=0;j<=bit;j++) 
               {if(zbit(carry,j))   // se il carry e' nullo il procedimento 
                  fine++; }                    // si interrompe
        };

       zcopy(somma,&resto);  
       zlshift(resto,1,&resto);
  
     }
   
  };

 
  for(i=0;i<2*bit;i++)
     if(zbit(t,2*bit-1-i))
       printf("t%d &\n",i);       // k contiene la rappresentazione binaria di 1/n troncata al bit 2*bit-iesimo.
       else printf("~t%d &\n",i);
   
   return;
};
  


main(int argc, char *argv[])
{  verylong mess = 0, modulo = 0, aux = 0, max = 0, firma=0;
   verylong negato = 0, complemento=0;
   long n_bit,riporto;
   register long i;
   i=0;
   // Dalla linea di comando si ricevono il modulo e la firma
   while(++i<argc)
        if (strcmp(argv[i],"-m")==0) {
            i++;
            zsread(argv[i], &modulo); }
        else if (strcmp(argv[i],"-f" )==0) {
                 i++;
                 zsread(argv[i], &firma); }
       
   n_bit = z2log(modulo);
   zintoz(2,&aux);
   zsexp(aux,n_bit,&max);       // max e' il numero massimo di bit per la
                                // rappresentazione della firma, calcolato
                                // in base al valore di n      
  
  
   zsexpmod(firma,3,modulo,&mess);   // (f*f*f) mod n 
   
  
   znot(modulo,&negato);        // si calcola il complemento a due del modulo
   i=0;
   riporto=1;
   while( i<n_bit)
    { if(!(zbit(negato,i) && 1))
         riporto=0;
      if(zbit(negato,i+1) ^ riporto)
         zsetbit(&complemento,i+1);
      i++;
    };
   if(zbit(negato,0) ^ 1)
      zsetbit(&complemento,0);
   zsetbit(&complemento,n_bit);

   
   codifica_n(n_bit,complemento);
   codifica_t(modulo,n_bit,complemento);
  
   codifica_m(mess,n_bit); 

   printf("\n");
   
}
