/**************** file cod-circuito.c *************************
*                                                             *
*   Questo file ha il compito di istanziare la codifica RSA   *
*   per il numero di bit specificato sulla linea di comando,  *
*   utilizzando il formalismo accettato da Heerhugo.          *
*                                                             *
*   Comando da utilizzare:                                    *
*   ----------------------                                    *
*   cod-circuito -b n_bit                                              *
*                                                             *
*   n_bit = numero di bit del modulo                          *
*                                                             * 
**************************************************************/


#include <stdio.h>

main(int argc, char* argv[])
{
   int b,i,j,z;
   while((--argc>0)&&(*++argv)[0]=='-')
	switch((*argv)[1]){
		case 'b':
                        sscanf(*argv,"-b%d",&b);
			break;
                default:
			printf("Opzione illegale\n");
			exit(1);
		}; 
   
    for(i=0;i<b+1;i++)
        printf("(d%d <-> ((p%d & ~c%d & ~q%d)|(~p%d & c%d & "
               "~q%d)|(~p%d & ~c%d & q%d)|(p%d & c%d & q%d))) "
               "&\n",i,i,i,i,i,i,i,i,i,i,i,i,i );

    printf(" ~q0 &\n");

    for(i=0;i<b+1;i++)
        printf("(q%d <-> ((p%d & c%d)|(p%d & ~c%d & q%d)|"
               "(~p%d & c%d & q%d))) &\n",i+1,i,i,i,i,i,i,i,i );

    for(i=0;i<b+1;i++)
        printf("(x%d <-> ((d%d & ~e%d & ~u%d)|(~d%d & e%d & ~u%d)|"   
             "(~d%d & ~e%d & u%d)|(d%d & e%d & u%d)))"
             "&\n",i,i,i,i,i,i,i,i,i,i,i,i,i );  
    
    printf(" ~u0 &\n");

    for(i=0;i<b+1;i++)
        printf("(u%d <-> ((d%d & e%d)|(d%d & ~e%d & u%d)|"
               "(~d%d & e%d & u%d))) &\n",i+1,i,i,i,i,i,i,i,i );

    for(i=0;i<b;i++)
        printf("(m%d <-> ((x%d & zero)|(d%d & ~zero))) &\n",i,i,i);

    printf("(zero <-> ~x%d) &\n",b);

    printf("(p0 <-> g0_0) &\n"); 

    for(i=1;i<b;i++)
        printf("(p%d <-> s%d_0) &\n",i,i-1);
        

    for(i=0;i<=b-2;i++)
        printf("(p%d <-> s%d_%d) &\n",i+b,b-1,i);
         

 
    printf("(p%d <-> h%d_%d) &\n",2*b-1,b-1,b-2);

    for(i=0;i<b;i++)
      for(j=0;j<b;j++)
        printf("(g%d_%d <-> (f%d & f%d)) &\n",i,j,i,j);

    for(i=0;i<b-1;i++)
        printf("(s0_%d <-> (g0_%d <-> ~g%d_0)) &\n",i,i+1,i+1);

    for(i=1;i<=(b-2);i++)
      for(j=0;j<=(b-3);j++) 
          printf("(s%d_%d <-> ((h%d_%d & ~s%d_%d & "
               "~g%d_%d)|(~h%d_%d & s%d_%d & "
               "~g%d_%d)|(~h%d_%d & ~s%d_%d & "
               "g%d_%d)|(h%d_%d & "
               "s%d_%d & g%d_%d))) "
             "&\n",i,j,i-1,j,i-1,j+1,j+1,i,i-1,j,i-1,j+1,j+1,i,i-1,j,i-1,j+1,j+1,i,i-1,j,i-1,j+1,j+1,i); 

    for(i=1;i<=b-2;i++)
          printf("(s%d_%d <-> ((h%d_%d & ~g%d_%d & "
               "~g%d_%d)|(~h%d_%d & g%d_%d & "
               "~g%d_%d)|(~h%d_%d & ~g%d_%d & "
               "g%d_%d)|(h%d_%d & "
               "g%d_%d & g%d_%d))) "
             "&\n",i,b-2,i-1,b-2,i,b-1,b-1,i,i-1,b-2,i,b-1,b-1,i,i-1,b-2,i,b-1,b-1,i,i-1,b-2,i,b-1,b-1,i); 

    
    printf("(s%d_0 <-> (h%d_0 <-> ~s%d_1)) "
           "&\n",b-1,b-2,b-2);  

    for(i=1;i<b;i++)
        if(i != b-2)
           {  j=b-1;
              z=i-1;
              printf("(s%d_%d <-> ((h%d_%d & ~s%d_%d & "
               "~h%d_%d)|(~h%d_%d & s%d_%d & "
               "~h%d_%d)|(~h%d_%d & ~s%d_%d & "
               "h%d_%d)|(h%d_%d & "
               "s%d_%d & h%d_%d))) "
              "&\n",j,i,j-1,i,j-1,i+1,j,z,j-1,i,j-1,i+1,j,z,j-1,i,j-1,i+1,j,z,j-1,i,j-1,i+1,j,z); 
            }; 
   
    i=b-1;
    j=b-2;
    z=b-3; 
    printf("(s%d_%d <-> ((h%d_%d & ~g%d_%d & "
               "~h%d_%d)|(~h%d_%d & g%d_%d & "
               "~h%d_%d)|(~h%d_%d & ~g%d_%d & "
               "h%d_%d)|(h%d_%d & "
               "g%d_%d & h%d_%d))) "
               "&\n",i,j,j,j,i,i,i,z,j,j,i,i,i,z,j,j,i,i,i,z,j,j,i,i,i,z); 

    for(i=0;i<=b-2;i++)
        printf("(h0_%d <-> (g0_%d & g%d_0)) &\n",i,i+1,i+1);
     
    for(i=0;i<(b-2);i++)
      for(j=0;j<(b-2);j++) 
        printf("(h%d_%d <-> ((g%d_%d & h%d_%d)|(g%d_%d "
               "& s%d_%d)|(h%d_%d & s%d_%d))) "
               "&\n",i+1,j,j+1,i+1,i,j,j+1,i+1,i,j+1,i,j,i,j+1); 
 
      
    for(i=1;i<=b-2;i++)
      printf("(h%d_%d <-> ((h%d_%d & g%d_%d)|(h%d_%d "
	     "& g%d_%d)|(g%d_%d & g%d_%d))) "
	     "&\n",i,b-2,i-1,b-2,i,b-1,i-1,b-2,b-1,i,i,b-1,b-1,i); 
    
    i=b-1;    
    printf("(h%d_0 <-> (h%d_0 & s%d_1)) &\n",i,i-1,i-1);

    for(i=1;i<b;i++)
        if(i != b-2)
           {   j=b-1;
               z=i-1;
               printf("(h%d_%d <-> ((h%d_%d & s%d_%d)|(h%d_%d "
                   "& h%d_%d)|(s%d_%d & h%d_%d))) "         
                   "&\n",j,i,j-1,i,j-1,i+1,j-1,i,j,z,j-1,i+1,j,z); }; 

    i=b-1;
    j=b-2;
    printf("(h%d_%d <-> ((h%d_%d & g%d_%d)|(h%d_%d "
                   "& h%d_%d)|(g%d_%d & h%d_%d))) "         
                   "&\n",i,j,j,j,i,i,j,j,i,j-1,i,i,i,j-1); 
          


    
    printf("(r0 <-> l0_0) &\n"); 

    for(i=1;i<(2*b);i++)
       { j=i-1;
         printf("(r%d <-> w%d_0) &\n",i,j);};

    for(i=0;i<=b;i++)
        {  j=2*b-1;
           printf("(r%d <-> w%d_%d) &\n",i+2*b,j,i);};

    for(i=((3*b)+1);i<(2*b);i++)
        printf("~r%d &\n",i);

    for(i=0;i<(2*b);i++)
      for(j=0;j<(2*b);j++)
        printf("(l%d_%d <-> (p%d & t%d)) &\n",i,j,i,j);

    for(i=0;i<(2*b-1);i++)
        printf("(w0_%d <-> (l0_%d <-> ~l%d_0)) &\n",i,i+1,i+1);

    for(i=1;i<=(2*b-2);i++)
      for(j=0;j<=(2*b-3);j++) 
        {      z=i-1;
               printf("(w%d_%d <-> ((v%d_%d & ~w%d_%d & "
               "~l%d_%d)|(~v%d_%d & w%d_%d & "
               "~l%d_%d)|(~v%d_%d & ~w%d_%d & "
               "l%d_%d)|(v%d_%d & "
               "w%d_%d & l%d_%d))) "
              "&\n",i,j,z,j,z,j+1,j+1,i,z,j,z,j+1,j+1,i,z,j,z,j+1,j+1,i,z,j,z,j+1,j+1,i);}; 

    for(i=1;i<=(2*b-2);i++)
        { j=2*b-2;
          z=i-1;
          printf("(w%d_%d <-> ((v%d_%d & ~l%d_%d & "
               "~l%d_%d)|(~v%d_%d & l%d_%d & "
               "~l%d_%d)|(~v%d_%d & ~l%d_%d & "
               "l%d_%d)|(v%d_%d & "
               "l%d_%d & l%d_%d))) "
              "&\n",i,j,z,j,i,j+1,j+1,i,z,j,i,j+1,j+1,i,z,j,i,j+1,j+1,i,z,j,i,j+1,j+1,i); } 

    i=2*b-1;
    j=2*b-2;
    printf("(w%d_0 <-> (v%d_0 <-> ~w%d_1)) "
           "&\n",i,j,j);  

    for(i=1;i<2*b;i++)
        if(i != 2*b-2)
           {  j=2*b-1;
              z=i-1;
               printf("(w%d_%d <-> ((v%d_%d & ~w%d_%d & "
               "~v%d_%d)|(~v%d_%d & w%d_%d & "
               "~v%d_%d)|(~v%d_%d & ~w%d_%d & "
               "v%d_%d)|(v%d_%d & "
               "w%d_%d & v%d_%d))) "
              "&\n",j,i,j-1,i,j-1,i+1,j,z,j-1,i,j-1,i+1,j,z,j-1,i,j-1,i+1,j,z,j-1,i,j-1,i+1,j,z); 
           };


    i=2*b-1;
    j=2*b-2;
    z=2*b-3; 
    printf("(w%d_%d <-> ((v%d_%d & ~l%d_%d & "
               "~v%d_%d)|(~v%d_%d & l%d_%d & "
               "~v%d_%d)|(~v%d_%d & ~l%d_%d & "
               "v%d_%d)|(v%d_%d & "
               "l%d_%d & v%d_%d))) "
               "&\n",i,j,j,j,i,i,i,z,j,j,i,i,i,z,j,j,i,i,i,z,j,j,i,i,i,z);
               
    for(i=0;i<=(2*b-2);i++)
        printf("(v0_%d <-> (l0_%d & l%d_0)) &\n",i,i+1,i+1);

     
    for(i=0;i<(2*b-2);i++)
      for(j=0;j<(2*b-2);j++) 
        printf("(v%d_%d <-> ((l%d_%d & v%d_%d)|(l%d_%d "
               "& w%d_%d)|(v%d_%d & w%d_%d))) "
               "&\n",i+1,j,j+1,i+1,i,j,j+1,i+1,i,j+1,i,j,i,j+1); 
 
      
    for(i=1;i<=(2*b-2);i++)
        {  j=2*b-1;
           z=i-1;
           printf("(v%d_%d <-> ((v%d_%d & l%d_%d)|(v%d_%d "
               "& l%d_%d)|(l%d_%d & l%d_%d))) "
               "&\n",i,j-1,z,j-1,i,j,z,j-1,j,i,i,j,j,i); 
         };
    
    i=2*b-1;    
    
    printf("(v%d_0 <-> (v%d_0 & w%d_1)) &\n",i,i-1,i-1);

    
          
    for(i=1;i<2*b;i++)
        if(i != 2*b-2)
            {  j=2*b-1;
               z=i-1;
                   printf("(v%d_%d <-> ((v%d_%d & w%d_%d)|(v%d_%d "
                   "& v%d_%d)|(w%d_%d & v%d_%d))) "           
                   "&\n",j,i,j-1,i,j-1,i+1,j-1,i,j,z,j-1,i+1,j,z); }; 

    i=2*b-1;
    j=2*b-2;               
    printf("(v%d_%d <-> ((v%d_%d & l%d_%d)|(v%d_%d "
                   "& v%d_%d)|(l%d_%d & v%d_%d))) "         
                   "&\n",i,j,j,j,i,i,j,j,i,j-1,i,i,i,j-1); 



    for(i=0;i<b+1;i++)
        printf("(k%d <-> r%d) &\n",i,i+(2*b));
  
    printf("(c0 <-> i0_0) &\n"); 

      
    for(i=1;i<b+1;i++)
       { j=i-1;
        printf("(c%d <-> z%d_0) &\n",i,j);
        };

    for(i=0;i<=b-1;i++)
         { j=b;
          printf("(c%d <-> z%d_%d) &\n",i+b+1,j,i);
         };

    j=2*(b+1)-1;
    i=b;
    z=b-1;
    printf("(c%d <-> a%d_%d) &\n",j,i,z);

    
    for(i=0;i<b+1;i++)
      for(j=0;j<b+1;j++)
        printf("(i%d_%d <-> (k%d & e%d)) &\n",i,j,i,j);

    for(i=0;i<b;i++)
        printf("(z0_%d <-> (i0_%d <-> ~i%d_0)) &\n",i,i+1,i+1);

 
   for(i=1;i<=(b-1);i++)
      for(j=0;j<=(b-2);j++) 
        { z=i-1;
          printf("(z%d_%d <-> ((a%d_%d & ~z%d_%d & "
               "~i%d_%d)|(~a%d_%d & z%d_%d & "
               "~i%d_%d)|(~a%d_%d & ~z%d_%d & "
               "i%d_%d)|(a%d_%d & "
               "z%d_%d & i%d_%d))) "
              "&\n",i,j,z,j,z,j+1,j+1,i,z,j,z,j+1,j+1,i,z,j,z,j+1,j+1,i,z,j,z,j+1,j+1,i); }

    for(i=1;i<=b-1;i++)
        { j=b-1;
          z=i-1;
          printf("(z%d_%d <-> ((a%d_%d & ~i%d_%d & "
               "~i%d_%d)|(~a%d_%d & i%d_%d & "
               "~i%d_%d)|(~a%d_%d & ~i%d_%d & "
               "i%d_%d)|(a%d_%d & "
               "i%d_%d & i%d_%d))) "
              "&\n",i,j,z,j,i,b,b,i,z,j,i,b,b,i,z,j,i,b,b,i,z,j,i,b,b,i); } 

    
    j=b-1;
    printf("(z%d_0 <-> (a%d_0<-> ~z%d_1)) "
           "&\n",b,j,j);  

    for(i=1;i<b+1;i++)
        if(i != b-1)
           {  j=b;
              z=i-1;
              printf("(z%d_%d <-> ((a%d_%d & ~z%d_%d & "
               "~a%d_%d)|(~a%d_%d & z%d_%d & "
               "~a%d_%d)|(~a%d_%d & ~z%d_%d & "
               "a%d_%d)|(a%d_%d & "
               "z%d_%d & a%d_%d))) "
              "&\n",j,i,j-1,i,j-1,i+1,j,z,j-1,i,j-1,i+1,j,z,j-1,i,j-1,i+1,j,z,j-1,i,j-1,i+1,j,z); 
            };

    i=b;
    j=b-1;
    z=b-2; 
    printf("(z%d_%d <-> ((a%d_%d & ~i%d_%d & "
               "~a%d_%d)|(~a%d_%d & i%d_%d & "
               "~a%d_%d)|(~a%d_%d & ~i%d_%d & "
               "a%d_%d)|(a%d_%d & "
               "i%d_%d & a%d_%d))) "
              "&\n",i,j,j,j,i,i,i,z,j,j,i,i,i,z,j,j,i,i,i,z,j,j,i,i,i,z); 


    for(i=0;i<=b-1;i++)
        printf("(a0_%d <-> (i0_%d & i%d_0)) &\n",i,i+1,i+1);

     
    for(i=0;i<(b-1);i++)
      for(j=0;j<(b-1);j++) 
        printf("(a%d_%d <-> ((i%d_%d & a%d_%d)|(i%d_%d "
               "& z%d_%d)|(a%d_%d & z%d_%d))) "
               "&\n",i+1,j,j+1,i+1,i,j,j+1,i+1,i,j+1,i,j,i,j+1); 
 
  
 
   
   
    for(i=1;i<=b-1;i++)
         {  j=b;
            z=i-1;
            printf("(a%d_%d <-> ((a%d_%d & i%d_%d)|(a%d_%d "
               "& i%d_%d)|(i%d_%d & i%d_%d))) "
               "&\n",i,j-1,z,j-1,i,j,z,j-1,j,i,i,j,j,i); 
         };

      
    printf("(a%d_0 <-> (a%d_0 & z%d_1)) &\n",b,b-1,b-1);

    for(i=1;i<b+1;i++)
        if(i != b-1)
            printf("(a%d_%d <-> ((a%d_%d & z%d_%d)|(a%d_%d "
                   "& a%d_%d)|(z%d_%d & a%d_%d))) "         
                   "&\n",b,i,b-1,i,b-1,i+1,b-1,i,b,i-1,b-1,i+1,b,i-1); 

    printf("(a%d_%d <-> ((a%d_%d & i%d_%d)|(a%d_%d "
                   "& a%d_%d)|(i%d_%d & a%d_%d))) "         
              "&\n",b,b-1,b-1,b-1,b,b,b-1,b-1,b,b-2,b,b,b,b-2);  

   

 for(i=0;i<b+1;i++)
        printf("(d_%d <-> ((p_%d & ~c_%d & ~q_%d)|(~p_%d & c_%d & "
               "~q_%d)|(~p_%d & ~c_%d & q_%d)|(p_%d & c_%d & q_%d))) "
               "&\n",i,i,i,i,i,i,i,i,i,i,i,i,i );

    printf(" ~q_0 &\n");

    for(i=0;i<b+1;i++)
        printf("(q_%d <-> ((p_%d & c_%d)|(p_%d & ~c_%d & q_%d)|"
               "(~p_%d & c_%d & q_%d))) &\n",i+1,i,i,i,i,i,i,i,i );

    for(i=0;i<b+1;i++)
        printf("(x_%d <-> ((d_%d & ~e%d & ~u_%d)|(~d_%d & e%d& ~u_%d)|"   
             "(~d_%d & ~e%d & u_%d)|(d_%d & e%d & u_%d)))"
             "&\n",i,i,i,i,i,i,i,i,i,i,i,i,i );  
    
    printf(" ~u_0 &\n");

    for(i=0;i<b+1;i++)
        printf("(u_%d <-> ((d_%d & e%d)|(d_%d & ~e%d & u_%d)|"
               "(~d_%d & e%d & u_%d))) &\n",i+1,i,i,i,i,i,i,i,i );

    for(i=0;i<b;i++)
        printf("(m_%d <-> ((x_%d & zero_1)|(d_%d & ~zero_1))) &\n",i,i,i);

    printf("(zero_1 <-> ~x_%d) &\n",b);

    printf("(p_0 <-> g_0_0) &\n"); 

    for(i=1;i<b;i++)
        printf("(p_%d <-> s_%d_0) &\n",i,i-1);
        

    for(i=0;i<=b-2;i++)
        printf("(p_%d <-> s_%d_%d) &\n",i+b,b-1,i);
         

 
    printf("(p_%d <-> h_%d_%d) &\n",2*b-1,b-1,b-2);

    for(i=0;i<b;i++)
      for(j=0;j<b;j++)
        printf("(g_%d_%d <-> (m%d & f%d)) &\n",i,j,i,j);

    for(i=0;i<b-1;i++)
        printf("(s_0_%d <-> (g_0_%d <-> ~g_%d_0)) &\n",i,i+1,i+1);

    for(i=1;i<=(b-2);i++)
      for(j=0;j<=(b-3);j++) 
          printf("(s_%d_%d <-> ((h_%d_%d & ~s_%d_%d & "
               "~g_%d_%d)|(~h_%d_%d & s_%d_%d & "
               "~g_%d_%d)|(~h_%d_%d & ~s_%d_%d & "
               "g_%d_%d)|(h_%d_%d & "
               "s_%d_%d & g_%d_%d))) "
             "&\n",i,j,i-1,j,i-1,j+1,j+1,i,i-1,j,i-1,j+1,j+1,i,i-1,j,i-1,j+1,j+1,i,i-1,j,i-1,j+1,j+1,i); 

    for(i=1;i<=b-2;i++)
          printf("(s_%d_%d <-> ((h_%d_%d & ~g_%d_%d & "
               "~g_%d_%d)|(~h_%d_%d & g_%d_%d & "
               "~g_%d_%d)|(~h_%d_%d & ~g_%d_%d & "
               "g_%d_%d)|(h_%d_%d & "
               "g_%d_%d & g_%d_%d))) "
             "&\n",i,b-2,i-1,b-2,i,b-1,b-1,i,i-1,b-2,i,b-1,b-1,i,i-1,b-2,i,b-1,b-1,i,i-1,b-2,i,b-1,b-1,i); 

    
    printf("(s_%d_0 <-> (h_%d_0 <-> ~s_%d_1)) "
           "&\n",b-1,b-2,b-2);  

    for(i=1;i<b;i++)
        if(i != b-2)
           {  j=b-1;
              z=i-1;
              printf("(s_%d_%d <-> ((h_%d_%d & ~s_%d_%d & "
               "~h_%d_%d)|(~h_%d_%d & s_%d_%d & "
               "~h_%d_%d)|(~h_%d_%d & ~s_%d_%d & "
               "h_%d_%d)|(h_%d_%d & "
               "s_%d_%d & h_%d_%d))) "
              "&\n",j,i,j-1,i,j-1,i+1,j,z,j-1,i,j-1,i+1,j,z,j-1,i,j-1,i+1,j,z,j-1,i,j-1,i+1,j,z); 
            }; 
   
    i=b-1;
    j=b-2;
    z=b-3; 
    printf("(s_%d_%d <-> ((h_%d_%d & ~g_%d_%d & "
               "~h_%d_%d)|(~h_%d_%d & g_%d_%d & "
               "~h_%d_%d)|(~h_%d_%d & ~g_%d_%d & "
               "h_%d_%d)|(h_%d_%d & "
               "g_%d_%d & h_%d_%d))) "
               "&\n",i,j,j,j,i,i,i,z,j,j,i,i,i,z,j,j,i,i,i,z,j,j,i,i,i,z); 

    for(i=0;i<=b-2;i++)
        printf("(h_0_%d <-> (g_0_%d & g_%d_0)) &\n",i,i+1,i+1);
     
    for(i=0;i<(b-2);i++)
      for(j=0;j<(b-2);j++) 
        printf("(h_%d_%d <-> ((g_%d_%d & h_%d_%d)|(g_%d_%d "
               "& s_%d_%d)|(h_%d_%d & s_%d_%d))) "
               "&\n",i+1,j,j+1,i+1,i,j,j+1,i+1,i,j+1,i,j,i,j+1); 
 
      
    for(i=1;i<=b-2;i++)
        {  j=b-1;
           z=i-1;
           printf("(h_%d_%d <-> ((h_%d_%d & g_%d_%d)|(h_%d_%d "
               "& g_%d_%d)|(g_%d_%d & g_%d_%d))) "
               "&\n",i,j-1,z,j-1,i,j,z,j-1,j,i,i,j,j,i); 
         };
    
    i=b-1;    
    printf("(h_%d_0 <-> (h_%d_0 & s_%d_1)) &\n",i,i-1,i-1);

    for(i=1;i<b;i++)
        if(i != b-2)
           {   j=b-1;
               z=i-1;
               printf("(h_%d_%d <-> ((h_%d_%d & s_%d_%d)|(h_%d_%d "
                   "& h_%d_%d)|(s_%d_%d & h_%d_%d))) "         
                   "&\n",j,i,j-1,i,j-1,i+1,j-1,i,j,z,j-1,i+1,j,z); }; 

    i=b-1;
    j=b-2;
    printf("(h_%d_%d <-> ((h_%d_%d & g_%d_%d)|(h_%d_%d "
                   "& h_%d_%d)|(g_%d_%d & h_%d_%d))) "         
                   "&\n",i,j,j,j,i,i,j,j,i,j-1,i,i,i,j-1); 
          


    
    printf("(r_0 <-> l_0_0) &\n"); 

    for(i=1;i<(2*b);i++)
       { j=i-1;
         printf("(r_%d <-> w_%d_0) &\n",i,j);};

    for(i=0;i<=b;i++)
        {  j=2*b-1;
           printf("(r_%d <-> w_%d_%d) &\n",i+2*b,j,i);};

    for(i=((3*b)+1);i<(2*b);i++)
        printf("~r_%d &\n",i);

    for(i=0;i<(2*b);i++)
      for(j=0;j<(2*b);j++)
        printf("(l_%d_%d <-> (p_%d & t%d)) &\n",i,j,i,j);

    for(i=0;i<(2*b-1);i++)
        printf("(w_0_%d <-> (l_0_%d <-> ~l_%d_0)) &\n",i,i+1,i+1);

    for(i=1;i<=(2*b-2);i++)
      for(j=0;j<=(2*b-3);j++) 
        {      z=i-1;
               printf("(w_%d_%d <-> ((v_%d_%d & ~w_%d_%d & "
               "~l_%d_%d)|(~v_%d_%d & w_%d_%d & "
               "~l_%d_%d)|(~v_%d_%d & ~w_%d_%d & "
               "l_%d_%d)|(v_%d_%d & "
               "w_%d_%d & l_%d_%d))) "
              "&\n",i,j,z,j,z,j+1,j+1,i,z,j,z,j+1,j+1,i,z,j,z,j+1,j+1,i,z,j,z,j+1,j+1,i);}; 

    for(i=1;i<=(2*b-2);i++)
        { j=2*b-2;
          z=i-1;
          printf("(w_%d_%d <-> ((v_%d_%d & ~l_%d_%d & "
               "~l_%d_%d)|(~v_%d_%d & l_%d_%d & "
               "~l_%d_%d)|(~v_%d_%d & ~l_%d_%d & "
               "l_%d_%d)|(v_%d_%d & "
               "l_%d_%d & l_%d_%d))) "
              "&\n",i,j,z,j,i,j+1,j+1,i,z,j,i,j+1,j+1,i,z,j,i,j+1,j+1,i,z,j,i,j+1,j+1,i); } 

    i=2*b-1;
    j=2*b-2;
    printf("(w_%d_0 <-> (v_%d_0 <-> ~w_%d_1)) "
           "&\n",i,j,j);  

    for(i=1;i<2*b;i++)
        if(i != 2*b-2)
           {  j=2*b-1;
              z=i-1;
               printf("(w_%d_%d <-> ((v_%d_%d & ~w_%d_%d & "
               "~v_%d_%d)|(~v_%d_%d & w_%d_%d & "
               "~v_%d_%d)|(~v_%d_%d & ~w_%d_%d & "
               "v_%d_%d)|(v_%d_%d & "
               "w_%d_%d & v_%d_%d))) "
              "&\n",j,i,j-1,i,j-1,i+1,j,z,j-1,i,j-1,i+1,j,z,j-1,i,j-1,i+1,j,z,j-1,i,j-1,i+1,j,z); 
           };


    i=2*b-1;
    j=2*b-2;
    z=2*b-3; 
    printf("(w_%d_%d <-> ((v_%d_%d & ~l_%d_%d & "
               "~v_%d_%d)|(~v_%d_%d & l_%d_%d & "
               "~v_%d_%d)|(~v_%d_%d & ~l_%d_%d & "
               "v_%d_%d)|(v_%d_%d & "
               "l_%d_%d & v_%d_%d))) "
               "&\n",i,j,j,j,i,i,i,z,j,j,i,i,i,z,j,j,i,i,i,z,j,j,i,i,i,z);
               
    for(i=0;i<=(2*b-2);i++)
        printf("(v_0_%d <-> (l_0_%d & l_%d_0)) &\n",i,i+1,i+1);

     
    for(i=0;i<(2*b-2);i++)
      for(j=0;j<(2*b-2);j++) 
        printf("(v_%d_%d <-> ((l_%d_%d & v_%d_%d)|(l_%d_%d "
               "& w_%d_%d)|(v_%d_%d & w_%d_%d))) "
               "&\n",i+1,j,j+1,i+1,i,j,j+1,i+1,i,j+1,i,j,i,j+1); 
 
      
    for(i=1;i<=(2*b-2);i++)
        {  j=2*b-1;
           z=i-1;
           printf("(v_%d_%d <-> ((v_%d_%d & l_%d_%d)|(v_%d_%d "
               "& l_%d_%d)|(l_%d_%d & l_%d_%d))) "
               "&\n",i,j-1,z,j-1,i,j,z,j-1,j,i,i,j,j,i); 
         };
    
    i=2*b-1;    
    
    printf("(v_%d_0 <-> (v_%d_0 & w_%d_1)) &\n",i,i-1,i-1);

    
          
    for(i=1;i<2*b;i++)
        if(i != 2*b-2)
            {  j=2*b-1;
               z=i-1;
                   printf("(v_%d_%d <-> ((v_%d_%d & w_%d_%d)|(v_%d_%d "
                   "& v_%d_%d)|(w_%d_%d & v_%d_%d))) "           
                   "&\n",j,i,j-1,i,j-1,i+1,j-1,i,j,z,j-1,i+1,j,z); }; 

    i=2*b-1;
    j=2*b-2;               
    printf("(v_%d_%d <-> ((v_%d_%d & l_%d_%d)|(v_%d_%d "
                   "& v_%d_%d)|(l_%d_%d & v_%d_%d))) "         
                   "&\n",i,j,j,j,i,i,j,j,i,j-1,i,i,i,j-1); 



    for(i=0;i<b+1;i++)
        printf("(k_%d <-> r_%d) &\n",i,i+(2*b));


  
    printf("(c_0 <-> i_0_0) &\n"); 

      
    for(i=1;i<b+1;i++)
       { j=i-1;
        printf("(c_%d <-> z_%d_0) &\n",i,j);
        };

    for(i=0;i<=b-1;i++)
         { j=b;
          printf("(c_%d <-> z_%d_%d) &\n",i+b+1,j,i);
         };

    j=2*(b+1)-1;
    i=b;
    z=b-1;
    printf("(c_%d <-> a_%d_%d) &\n",j,i,z);

    
    for(i=0;i<b+1;i++)
      for(j=0;j<b+1;j++)
        printf("(i_%d_%d <-> (k_%d & e%d)) &\n",i,j,i,j);

    for(i=0;i<b;i++)
        printf("(z_0_%d <-> (i_0_%d <-> ~i_%d_0)) &\n",i,i+1,i+1);

 
   for(i=1;i<=(b-1);i++)
      for(j=0;j<=(b-2);j++) 
        { z=i-1;
          printf("(z_%d_%d <-> ((a_%d_%d & ~z_%d_%d & "
               "~i_%d_%d)|(~a_%d_%d & z_%d_%d & "
               "~i_%d_%d)|(~a_%d_%d & ~z_%d_%d & "
               "i_%d_%d)|(a_%d_%d & "
               "z_%d_%d & i_%d_%d))) "
              "&\n",i,j,z,j,z,j+1,j+1,i,z,j,z,j+1,j+1,i,z,j,z,j+1,j+1,i,z,j,z,j+1,j+1,i); }

    for(i=1;i<=b-1;i++)
        { j=b-1;
          z=i-1;
          printf("(z_%d_%d <-> ((a_%d_%d & ~i_%d_%d & "
               "~i_%d_%d)|(~a_%d_%d & i_%d_%d & "
               "~i_%d_%d)|(~a_%d_%d & ~i_%d_%d & "
               "i_%d_%d)|(a_%d_%d & "
               "i_%d_%d & i_%d_%d))) "
              "&\n",i,j,z,j,i,b,b,i,z,j,i,b,b,i,z,j,i,b,b,i,z,j,i,b,b,i); } 

    
    j=b-1;
    printf("(z_%d_0 <-> (a_%d_0<-> ~z_%d_1)) "
           "&\n",b,j,j);  

    for(i=1;i<b+1;i++)
        if(i != b-1)
           {  j=b;
              z=i-1;
              printf("(z_%d_%d <-> ((a_%d_%d & ~z_%d_%d & "
               "~a_%d_%d)|(~a_%d_%d & z_%d_%d & "
               "~a_%d_%d)|(~a_%d_%d & ~z_%d_%d & "
               "a_%d_%d)|(a_%d_%d & "
               "z_%d_%d & a_%d_%d))) "
              "&\n",j,i,j-1,i,j-1,i+1,j,z,j-1,i,j-1,i+1,j,z,j-1,i,j-1,i+1,j,z,j-1,i,j-1,i+1,j,z); 
            };

    i=b;
    j=b-1;
    z=b-2; 
    printf("(z_%d_%d <-> ((a_%d_%d & ~i_%d_%d & "
               "~a_%d_%d)|(~a_%d_%d & i_%d_%d & "
               "~a_%d_%d)|(~a_%d_%d & ~i_%d_%d & "
               "a_%d_%d)|(a_%d_%d & "
               "i_%d_%d & a_%d_%d))) "
              "&\n",i,j,j,j,i,i,i,z,j,j,i,i,i,z,j,j,i,i,i,z,j,j,i,i,i,z); 


    for(i=0;i<=b-1;i++)
        printf("(a_0_%d <-> (i_0_%d & i_%d_0)) &\n",i,i+1,i+1);

     
    for(i=0;i<(b-1);i++)
      for(j=0;j<(b-1);j++) 
        printf("(a_%d_%d <-> ((i_%d_%d & a_%d_%d)|(i_%d_%d "
               "& z_%d_%d)|(a_%d_%d & z_%d_%d))) "
               "&\n",i+1,j,j+1,i+1,i,j,j+1,i+1,i,j+1,i,j,i,j+1); 
 
  
 
   
   
    for(i=1;i<=b-1;i++)
         {  j=b;
            z=i-1;
            printf("(a_%d_%d <-> ((a_%d_%d & i_%d_%d)|(a_%d_%d "
               "& i_%d_%d)|(i_%d_%d & i_%d_%d))) "
               "&\n",i,j-1,z,j-1,i,j,z,j-1,j,i,i,j,j,i); 
         };

      
    printf("(a_%d_0 <-> (a_%d_0 & z_%d_1)) &\n",b,b-1,b-1);

    for(i=1;i<b+1;i++)
        if(i != b-1)
            printf("(a_%d_%d <-> ((a_%d_%d & z_%d_%d)|(a_%d_%d "
                   "& a_%d_%d)|(z_%d_%d & a_%d_%d))) "         
                   "&\n",b,i,b-1,i,b-1,i+1,b-1,i,b,i-1,b-1,i+1,b,i-1); 

    printf("(a_%d_%d <-> ((a_%d_%d & i_%d_%d)|(a_%d_%d "
                   "& a_%d_%d)|(i_%d_%d & a_%d_%d))) "         
              "&\n",b,b-1,b-1,b-1,b,b,b-1,b-1,b,b-2,b,b,b,b-2);  

   


    
}



