#include <stdio.h>
#include <stdlib.h>
#include <string.h>

void balanced_product(FILE *mfile,int n)
{
  switch (flag_format) {
  case TPTP: if (flag_fof) 
                balanced_product_fof_fml(mfile,n/2);
             else if (flag_ground)
                balanced_product_grd_fml(mfile,n/2);
             else {
	       WARN("UNKNOWN Output for TPTP")
	       exit(1);
	     }
            break;
  case SMODELS: if (flag_ground)
                  balanced_product_grd_rules(mfile,n/2);
                else {
	          WARN("UNKNOWN Output for SMODELS")
	         exit(1);
	        } 
               break;
  case HUMAN:
  case CNF: WARN("Format not implemented")
	    exit(1);
  }
}

void product(FILE *mfile,int n)
{
  switch (flag_format) {
  case TPTP: if (flag_fof) 
                product_fof_fml(mfile,n);
             else if (flag_ground)
                product_grd_fml(mfile,n);
             else {
	       WARN("UNKNOWN Output for TPTP")
	       exit(1);
	     }
            break;
  case SMODELS: if (flag_ground)
                  product_grd_rules(mfile,n);
                else {
	          WARN("UNKNOWN Output for SMODELS")
	         exit(1);
	        } 
               break;
  case HUMAN:
  case CNF: WARN("Format not implemented")
	    exit(1);
  }
}

void value(FILE *mfile, char *A, int val, int n)
{
  switch (flag_format) {
  case TPTP: if (flag_fof) 
                value_fof_fml(mfile,A,val,n);
             else if (flag_ground)
                value_grd_fml(mfile,A,val,n);
             else {
	       WARN("UNKNOWN Output for TPTP")
	       exit(1);
	     }
            break;
  case SMODELS: if (flag_ground)
                  value_grd_rules(mfile,A,val,n);
                else {
	          WARN("UNKNOWN Output for SMODELS")
	         exit(1);
	        } 
               break;
  case HUMAN:
  case CNF: WARN("Format not implemented")
	    exit(1);
  }
}

void ordering(FILE *mfile,int n)
{
  switch (flag_format) {
  case TPTP: if (flag_fof) 
                ordering_fof_fml(mfile,n/2);
             else if (flag_ground)
                ordering_grd_fml(mfile,n/2);
             else {
	       WARN("UNKNOWN Output for TPTP")
	       exit(1);
	     }
            break;
  case SMODELS: if (flag_ground)
                  ordering_grd_rules(mfile,n/2);
                else {
	          WARN("UNKNOWN Output for SMODELS")
	         exit(1);
	        } 
               break;
  case HUMAN:
  case CNF: WARN("Format not implemented")
	    exit(1);
  }
}

void primality(FILE *mfile,int n)
{
  switch (flag_format) {
  case TPTP: if (flag_fof) 
                primality_fof_fml(mfile,n/2);
             else if (flag_ground)
                primality_grd_fml(mfile,n/2);
             else {
	       WARN("UNKNOWN Output for TPTP")
	       exit(1);
	     }
            break;
  case SMODELS: if (flag_ground)
                  primality_grd_rules(mfile,n/2);
                else {
	          WARN("UNKNOWN Output for SMODELS")
	         exit(1);
	        } 
               break;
  case HUMAN:
  case CNF: WARN("Format not implemented")
	    exit(1);
  }
}

void choices(FILE *mfile,char *A,int n)
{
   int i;
   if (flag_balance) n=n/2;
   for (i=0;i<n;i++)
     fprintf(mfile,"{ %s(%i) }.\n",A,i);
}
