#include <stdio.h>
#include <stdlib.h>
#include <string.h>

void header_fof_fml(FILE *mfile,char *name,int i, int j)
{
  fprintf(mfile,"input_formula(%s_%d_%d,hypothesis,(\n  ",name,i,j);
}

void footer_fof_fml(FILE *mfile)
{
  fprintf(mfile,"\n)).\n\n");
}


short Variable(short term)
{
  return (term==VarI || term==VarJ);
}

void term_fof_fml(FILE *mfile, 
	  short fun,
	  int parenthesis,
	  short var)
{
  int i;
  
  for (i=0;i<parenthesis;i++)
    fprintf(mfile,"%s(",sym_table[fun]);

  fprintf(mfile,"%s",sym_table[var]);

  for (i=0;i<parenthesis;i++)
    fprintf(mfile,")");
}     

void unary_1fof_fml(FILE *mfile,short defconn,
		char *A,
		short fun_a, int i_a, short var_a)
{
  header_fof_fml(mfile,A,i_a,var_a);
  if (Variable(var_a))
    fprintf(mfile,"%s [%s] :",sym_table[FORALL],sym_table[var_a]); 
  fprintf(mfile,"( %s%s(",
	 ((defconn==NEG)?sym_table[NEG]:""),
	 A);
  term_fof_fml(mfile,fun_a,i_a,var_a);
  fprintf(mfile,") )");
  footer_fof_fml(mfile);
}

void product_fof_fml(FILE *mfile,int n)
{
  /************************************/
  WARN("First Order Product Generation")

  header_fof_fml(mfile,"prod",0,0);
  fprintf(mfile,"![I,J] :( p(I,J) <=> (x(I) & y(J)) )");
  footer_fof_fml(mfile);

  /************************************/
  WARN("First Order Sum Generation")

  header_fof_fml(mfile,"sum",0,0);
  fprintf(mfile,"![J] :( s(%s,J) <=> (p(%s,%s(J)) <~> p(%s(J),%s)) )",
	  sym_table[ZERO],sym_table[ZERO],
	  sym_table[SUCC],sym_table[SUCC],
	  sym_table[ZERO]);
  footer_fof_fml(mfile);

  header_fof_fml(mfile,"sum",1,0);
  fprintf(mfile,"![I,J] :( s(%s(I),J) <=> (c(I,J) <~> s(I,%s(J)) <~> p(%s(J),%s(I))) )",
	  sym_table[SUCC],sym_table[SUCC],
	  sym_table[SUCC],sym_table[SUCC]);
  footer_fof_fml(mfile);


  /************************************/
  WARN("First Order Carry Generation")

  header_fof_fml(mfile,"pc",0,0);
  fprintf(mfile,"![I,J,H,K] :( pc(I,J,H,K) <=> (p(I,J) & c(H,K)) )");
  footer_fof_fml(mfile);
  header_fof_fml(mfile,"ps",0,0);
  fprintf(mfile,"![I,J,H,K] :( ps(I,J,H,K) <=> (p(I,J) & s(H,K)) )");
  footer_fof_fml(mfile);
  header_fof_fml(mfile,"cs",0,0);
  fprintf(mfile,"![I,J,H,K] :( cs(I,J,H,K) <=> (c(I,J) & s(H,K)) )");
  footer_fof_fml(mfile);

  header_fof_fml(mfile,"carry",0,0);
  fprintf(mfile,"![J] :( c(%s,J) <=> (p(%s,%s(J)) & p(%s(J),%s)))",
	  sym_table[ZERO],sym_table[ZERO],
	  sym_table[SUCC],sym_table[SUCC],
	  sym_table[ZERO]);
  footer_fof_fml(mfile);

  header_fof_fml(mfile,"carry",1,0);
  fprintf(mfile,"![I,J] :( c(%s(I),J) <=> (cs(I,J,I,%s(J)) | ps(%s(J),%s(I),I,%s(J)) | pc(%s(J),%s(I),I,J)) )",
	  sym_table[SUCC],
	  sym_table[SUCC],
	  sym_table[SUCC],sym_table[SUCC],sym_table[SUCC],
	  sym_table[SUCC],sym_table[SUCC]);
  footer_fof_fml(mfile);

  /************************************/
  WARN("First Order Output Generation")

  header_fof_fml(mfile,"mul",0,0);
  fprintf(mfile," m(%s) <=> p(%s,%s)",
	  sym_table[ZERO],sym_table[ZERO],
          sym_table[ZERO]);
  footer_fof_fml(mfile);

  header_fof_fml(mfile,"mul",1,0);
  fprintf(mfile,"![I] :( m(%s(I)) <=> s(I,%s) )",
	  sym_table[SUCC],sym_table[ZERO]);
  footer_fof_fml(mfile);

  /************************************/
  WARN("First order filtering of unwanted models")

   unary_1fof_fml(mfile,NEG,"x",SUCC,n,VarI);
   unary_1fof_fml(mfile,NEG,"y",SUCC,n,VarI);
   unary_1fof_fml(mfile,NEG,"m",SUCC,n,VarI);
}

void value_fof_fml(FILE *mfile, char *A, int val, int n)
{
  int i;

  for (i=0; i<n+1; i++) {
    unary_1fof_fml(mfile,((val%2==0)?NEG:POS),A,SUCC,i,ZERO);
    val=val/2;
  }

  if (val!=0)
    WARN("Value does not fit in specified-bits")
}

void balanced_product_fof_fml(FILE *mfile,int n)
{

  product_fof_fml(mfile,2*n);

  unary_1fof_fml(mfile,NEG,"x",SUCC,n,VarI);
  unary_1fof_fml(mfile,NEG,"y",SUCC,n,VarI);

}



void ordering_fof_fml(FILE *mfile,int n)
{

  header_fof_fml(mfile,"lex",0,0);
  fprintf(mfile,"![I] :( y(I) => lex(I) )");
  footer_fof_fml(mfile);

  header_fof_fml(mfile,"lex",1,0);
  fprintf(mfile,"![I] :( lex(I) => (x(I) | lex(%s(I)) )",
	  sym_table[SUCC]);
  footer_fof_fml(mfile);

   unary_1fof_fml(mfile,NEG,"lex",SUCC,n,VarI);
}


void primality_fof_fml(FILE *mfile,int n)
{

  header_fof_fml(mfile,"ge2x",0,0);
  fprintf(mfile,"~ge2x(%s)",
	  sym_table[ZERO]);
  footer_fof_fml(mfile);

  header_fof_fml(mfile,"g2x",1,0);
  fprintf(mfile,"![I] :( ge2x(%s(I)) <=> (x(%s(I)) | ge2x(I)) )",
	  sym_table[SUCC],sym_table[SUCC]);
  footer_fof_fml(mfile);

   unary_1fof_fml(mfile,POS,"ge2x",SUCC,n-1,VarI);

   header_fof_fml(mfile,"ge2y",0,0);
   fprintf(mfile,"~ge2y(%s)",
	   sym_table[ZERO]);
   footer_fof_fml(mfile);
   
   header_fof_fml(mfile,"g2y",1,0);
   fprintf(mfile,"![I] :( ge2y(%s(I)) <=> (y(%s(I)) | ge2y(I)) )",
	   sym_table[SUCC],sym_table[SUCC]);
   footer_fof_fml(mfile);
  
   unary_1fof_fml(mfile,POS,"ge2y",SUCC,n-1,VarI);
}



