#include <stdio.h>
#include <stdlib.h>
#include <string.h>

void header_grd_fml(FILE *mfile,char *name,int i, int j)
{
  fprintf(mfile,"input_formula(%s_%d_%d,hypothesis,(\n  ",name,i,j);
}

void footer_grd_fml(FILE *mfile)
{
  fprintf(mfile,"\n)).\n\n");
}

void unary_1grd_fml(FILE *mfile,short defconn,
	   char *A, int i_a)
{
  header_grd_fml(mfile,A,i_a,0);
  fprintf(mfile,"%s%s(%d)\n",
	 ((defconn==NEG)?sym_table[NEG]:" "),
	 A,i_a);
  footer_grd_fml(mfile);
}

void unary_1x1grd_fml(FILE *mfile,short defconn,
	     char *Def, int i_def,
	     short connective,
	     char *A, int i_a)
{
  header_grd_fml(mfile,Def,i_def,0);
  fprintf(mfile,"%s(%d) %s %s %s(%d)\n",
	 Def,i_def,
	   sym_table[defconn],
	   ((connective==NEG)?sym_table[NEG]:" "),
	 A,i_a);
  footer_grd_fml(mfile);
}

void unary_1x2grd_fml(FILE *mfile,short defconn,
	     char *Def, int i_def,
	     short connective,
	     char *A, int i_a, int j_a)
{
  header_grd_fml(mfile,Def,i_def,0);
  fprintf(mfile,"%s(%d) %s (%s %s(%d,%d))\n",
	 Def,i_def,
	   sym_table[defconn],
	   ((connective==NEG)?sym_table[NEG]:" "),
	 A,i_a,j_a);
  footer_grd_fml(mfile);
}

void binary_2x2grd_fml(FILE *mfile,short defconn,
	      char *Def, int i_def, int j_def,
	      short connective,
	      char *A, int i_a, int j_a,
	      char *B, int i_b, int j_b)
{  
  header_grd_fml(mfile,Def,i_def,j_def);
  fprintf(mfile,"%s(%d,%d) %s (%s(%d,%d) %s %s(%d,%d))\n",
	 Def,i_def,j_def,
	   sym_table[defconn],
	 A,i_a,j_a,
	   sym_table[connective],
	 B,i_b,j_b);
  footer_grd_fml(mfile);
}

void binary_1x1grd_fml(FILE *mfile,short defconn,
	      char *Def, int i_def,
	      short connective,
	      char *A, int i_a,
	      char *B, int i_b)
{  
  header_grd_fml(mfile,Def,i_def,0);
  fprintf(mfile,"%s(%d) %s (%s(%d) %s %s(%d))\n",
	 Def,i_def,
	   sym_table[defconn],
	 A,i_a,
	   sym_table[connective],
	 B,i_b);
  footer_grd_fml(mfile);
}

void binary_2x1grd_fml(FILE *mfile,short defconn,
		   char *Def, int i_def, int j_def,
		   short connective,
		   char *A, int i_a,
		   char *B, int i_b)
{  
  header_grd_fml(mfile,Def,i_def,j_def);
  fprintf(mfile,"%s(%d,%d) %s (%s(%d) %s %s(%d))\n",
	 Def,i_def,j_def,
	   sym_table[defconn],
	 A,i_a,
	   sym_table[connective],
	 B,i_b);
  footer_grd_fml(mfile);
}

void ternary_2x2grd_fml(FILE *mfile,short defconn,
		    char *Def, int i_def, int j_def,
		    short connective,
		    char *A, int i_a, int j_a,
		    char *B, int i_b, int j_b,
		    char *C, int i_c, int j_c)
{
  header_grd_fml(mfile,Def,i_def,j_def);
  fprintf(mfile,"%s(%d,%d) %s (%s(%d,%d) %s %s(%d,%d) %s %s(%d,%d))\n",
	 Def,i_def,j_def,
	   sym_table[defconn],
	 A,i_a,j_a,
	   sym_table[connective],
	 B,i_b,j_b,
	   sym_table[connective],
	 C,i_c,j_c);
  footer_grd_fml(mfile);
}


void binary_4x2grd_fml(FILE *mfile,short defconn,
	      char *Def, int i_def, int j_def, int k_def, int h_def,
	      short connective,
	      char *A, int i_a, int j_a,
	      char *B, int i_b, int j_b)
{  
  header_grd_fml(mfile,Def,i_def,j_def);
  fprintf(mfile,"%s(%d,%d,%d,%d) %s (%s(%d,%d) %s %s(%d,%d))\n",
	 Def,i_def,j_def,k_def,h_def,
	   sym_table[defconn],
	 A,i_a,j_a,
	   sym_table[connective],
	 B,i_b,j_b);
  footer_grd_fml(mfile);
}

void ternary_2x4grd_fml(FILE *mfile,short defconn,
	       char *Def, int i_def, int j_def,
	       short connective,
	       char *A, int i_a, int j_a, int h_a, int k_a,
	       char *B, int i_b, int j_b, int h_b, int k_b,
	       char *C, int i_c, int j_c, int h_c, int k_c)
{
  header_grd_fml(mfile,Def,i_def,j_def);
  fprintf(mfile,"%s(%d,%d) %s (%s(%d,%d,%d,%d) %s %s(%d,%d,%d,%d) %s %s(%d,%d,%d,%d))\n",
	 Def,i_def,j_def,
	   sym_table[defconn],
	 A,i_a,j_a,h_a,k_a,
	   sym_table[connective],
	 B,i_b,j_b,h_b,k_b,
	   sym_table[connective],
	 C,i_c,j_c,h_c,k_c);
  footer_grd_fml(mfile);
}


void balanced_product_grd_fml(FILE *mfile,int n)
{
  int i,j;

  /************************************/
  WARN("Balanced Product Generation")

  for (i=0;i<n;i++)
    for (j=0;j<n;j++)
      binary_2x1grd_fml(mfile,IFF,"p",i,j,AND,"x",i,"y",j);

  /************************************/
  WARN("Balanced Sum Generation")

  for(j=0;j<n-1;j++)
    binary_2x2grd_fml(mfile,IFF,"s",0,j,XOR,"p",0,j+1,"p",j+1,0);

  for(i=1;i<n-1;i++) {
    
    for(j=0;j<n-2;j++)
      ternary_2x2grd_fml(mfile,IFF,"s",i,j,XOR,"c",i-1,j,"s",i-1,j+1,"p",j+1,i);
    
    ternary_2x2grd_fml(mfile,IFF,"s",i,n-2,XOR,"c",i-1,n-2,"p",i,n-1,"p",n-1,i);
  }

  binary_2x2grd_fml(mfile,IFF,"s",n-1,0,XOR,"c",n-2,0,"s",n-2,1);

  for(j=1;j<n-2;j++)
    ternary_2x2grd_fml(mfile,IFF,"s",n-1,j,XOR,"c",n-2,j,"s",n-1,j+1,"c",n-1,j-1);
 
  ternary_2x2grd_fml(mfile,IFF,"s",n-1,n-2,XOR,"c",n-2,n-2,"p",n-1,n-1,"c",n-1,n-3);
  

  /************************************/
  WARN("Balanced Carry Generation")


  for(j=0;j<n-1;j++)
    binary_2x2grd_fml(mfile,IFF,"c",0,j,AND,"p",0,j+1,"p",j+1,0);

  for(i=1;i<n-1;i++) {
    
    for(j=0;j<n-2;j++) {
      binary_4x2grd_fml(mfile,IFF,"cp",i-1,j,j+1,i,AND,"c",i-1,j,"p",j+1,i);
      binary_4x2grd_fml(mfile,IFF,"cs",i-1,j,i-1,j+1,AND,"c",i-1,j,"s",i-1,j+1);
      binary_4x2grd_fml(mfile,IFF,"sp",i-1,j+1,j+1,i,AND,"s",i-1,j+1,"p",j+1,i);

      ternary_2x4grd_fml(mfile,IFF,"c",i,j,OR,
		     "cp",i-1,j,j+1,i,
		     "cs",i-1,j,i-1,j+1,
		     "sp",i-1,j+1,j+1,i);
    }    
    binary_4x2grd_fml(mfile,IFF,"cp1",i-1,n-2,i,n-1,AND,"c",i-1,n-2,"p",i,n-1);
    binary_4x2grd_fml(mfile,IFF,"cp2",i-1,n-2,n-1,i,AND,"c",i-1,n-2,"p",n-1,i);
    binary_4x2grd_fml(mfile,IFF,"pp",i,n-1,n-1,i,AND,"p",i,n-1,"p",n-1,i);

    ternary_2x4grd_fml(mfile,IFF,"c",i,n-2,OR,
		   "cp1",i-1,n-2,i,n-1,
		   "cp2",i-1,n-2,n-1,i,
		   "pp",i,n-1,n-1,i);
  }

  binary_2x2grd_fml(mfile,IFF,"c",n-1,0,AND,"c",n-2,0,"s",n-2,1);

  for(j=1;j<n-2;j++) {
    binary_4x2grd_fml(mfile,IFF,"cs",n-2,j,n-1,j+1,AND,"c",n-2,j,"s",n-1,j+1);
    binary_4x2grd_fml(mfile,IFF,"cc",n-2,j,n-1,j-1,AND,"c",n-2,j,"c",n-1,j-1);
    binary_4x2grd_fml(mfile,IFF,"sc",n-1,j+1,n-1,j-1,AND,"s",n-1,j+1,"c",n-1,j-1);

    ternary_2x4grd_fml(mfile,IFF,"c",n-1,j,OR,
		   "cs",n-2,j,n-1,j+1,
		   "cc",n-2,j,n-1,j-1,
		   "sc",n-1,j+1,n-1,j-1);
  }
  binary_4x2grd_fml(mfile,IFF,"cp",n-2,n-2,n-1,n-1,AND,"c",n-2,n-2,"p",n-1,n-1);
  binary_4x2grd_fml(mfile,IFF,"cc",n-2,n-2,n-1,n-3,AND,"c",n-2,n-2,"c",n-1,n-3);
  binary_4x2grd_fml(mfile,IFF,"pc",n-1,n-1,n-1,n-3,AND,"p",n-1,n-1,"c",n-1,n-3);

  ternary_2x4grd_fml(mfile,IFF,"c",n-1,n-2,OR,
		 "cp",n-2,n-2,n-1,n-1,
		 "cc",n-2,n-2,n-1,n-3,
		 "pc",n-1,n-1,n-1,n-3);
		 

  /************************************/
  WARN("Balanced Result Generation")

  unary_1x2grd_fml(mfile,IFF,"m",0,POS,"p",0,0);

  for(i=1;i<n;i++)
    unary_1x2grd_fml(mfile,IFF,"m",i,POS,"s",i-1,0);

  for(i=1;i<n;i++)
    unary_1x2grd_fml(mfile,IFF,"m",i+n-1,POS,"s",n-1,i-1);

  unary_1x2grd_fml(mfile,IFF,"m",2*n-1,POS,"c",n-1,n-2);

}


void product_grd_fml(FILE *mfile,int n)
{
  int i,j;

  /************************************/
  WARN("Product Generation")

  for (i=0;i<n;i++)
    for (j=0;j<i+1;j++)
      binary_2x1grd_fml(mfile,IFF,"p",i-j,j,AND,"x",i-j,"y",j);

  /************************************/
  WARN("Sum Generation")

  for(j=0;j<n-1;j++)
    binary_2x2grd_fml(mfile,IFF,"s",0,j,XOR,"p",0,j+1,"p",j+1,0);

  for(i=1;i<n-1;i++) {
    for(j=0;j<i;j++)
      ternary_2x2grd_fml(mfile,IFF,"s",i-j,j,XOR,"c",i-j-1,j,"s",i-j-1,j+1,"p",j+1,i-j);
  }  

  /************************************/
  WARN("Carry Generation")


  for(j=0;j<n-2;j++)
    binary_2x2grd_fml(mfile,IFF,"c",0,j,AND,"p",0,j+1,"p",j+1,0);

  for(i=1;i<n-2;i++)
    for(j=0;j<i;j++) {
      binary_4x2grd_fml(mfile,IFF,"cp",i-j-1,j,j+1,i,AND,"c",i-j-1,j,"p",j+1,i-j);
      binary_4x2grd_fml(mfile,IFF,"cs",i-j-1,j,i-j-1,j+1,AND,"c",i-j-1,j,"s",i-j-1,j+1);
      binary_4x2grd_fml(mfile,IFF,"sp",i-j-1,j+1,j+1,i-j,AND,"s",i-j-1,j+1,"p",j+1,i-j);

      ternary_2x4grd_fml(mfile,IFF,"c",i-j,j,OR,
		     "cp",i-j-1,j,j+1,i-j,
		     "cs",i-j-1,j,i-j-1,j+1,
		     "sp",i-j-1,j+1,j+1,i-j);
    }

  /************************************/
  WARN("Result Generation")

  unary_1x2grd_fml(mfile,IFF,"m",0,POS,"p",0,0);

  for(i=1;i<n;i++)
    unary_1x2grd_fml(mfile,IFF,"m",i,POS,"s",i-1,0);

}

void value_grd_fml(FILE *mfile, char *A, int val, int n)
{
  int i;

  for(i=0;i<n+1;i++) {
    unary_1grd_fml(mfile,((val%2==0)?NEG:POS),A,i);
    val=val/2;
  }

  if (val!=0)
    WARN("Value does not fit in specified-bits")
}


void balance_grd_fml(FILE *mfile,int n)
{
  int i;

  for(i=n;i<2*n;i++) {
    unary_1grd_fml(mfile,NEG,"x",i);
    unary_1grd_fml(mfile,NEG,"y",i);
  }
}

void ordering_grd_fml(FILE *mfile,int n)
{
  int i;

  for(i=0;i<n;i++) {
    unary_1x1grd_fml(mfile,IMP,"y",i,POS,"lex",i);
    binary_1x1grd_fml(mfile,IMP,"lex",i,OR,"x",i,"lex",i+1);
  }
  unary_1grd_fml(mfile,NEG,"lex",n);
}

void primality_grd_fml(FILE *mfile,int n)
{
  int i;

  unary_1grd_fml(mfile,NEG,"ge2x",0);

  for(i=1;i<n;i++) {
    binary_1x1grd_fml(mfile,IFF,"ge2x",i,OR,"x",i,"ge2x",i-1);
  }
  unary_1grd_fml(mfile,NEG,"ge2x",n-1);

  unary_1grd_fml(mfile,NEG,"ge2y",0);

  for(i=1;i<n;i++) {
    binary_1x1grd_fml(mfile,IFF,"ge2y",i,OR,"y",i,"ge2y",i-1);
  }
  unary_1grd_fml(mfile,NEG,"ge2y",n-1);
}



