#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/* char *strdup(const char *s1);
*/
void ScanParameters(int argc, char *argv[])
{
  int i;

  i=0;
  while(++i<argc)
    if (strcmp(argv[i],"-size")==0) {
      i++;
      Size=(int)atol(argv[i]);
    }
    else if (strcmp(argv[i],"-product")==0) {
      i++;
      Product=(int)atol(argv[i]);
    }
    else if (strcmp(argv[i],"-xfactor")==0) {
      i++;
      XFactor=(int)atol(argv[i]);
      flag_solX=1;
    }
    else if (strcmp(argv[i],"-yfactor")==0) {
      i++;
      YFactor=(int)atol(argv[i]);
      flag_solY=1;
    }
    else if (strcmp(argv[i],"-file")==0) {
      i++;
      ProblemFile=(char *)strdup(argv[i]);
    }
    else if (strcmp(argv[i],"-fof")==0) {
      flag_fof=1;
    }
    else if (strcmp(argv[i],"-ground")==0) {
      flag_ground=1;
    }
    else if (strcmp(argv[i],"-balance")==0) {
      flag_balance=1;
    }
    else if (strcmp(argv[i],"-order")==0) {
      flag_order=1;
    }
    else if (strcmp(argv[i],"-prime")==0) {
      flag_prime=1;
    }
    else if (strcmp(argv[i],"-format")==0) {
      i++;
      flag_format=(short)atoi(argv[i]);
      switch(flag_format) {
	case TPTP    : WARN("TPTP format")
		       break;
        case SMODELS : WARN("SMODELS format")
		       flag_ground=1;
	       	       break;
        case HUMAN   :
        case CNF     :  WARN("Format not implemented yet")
	                exit(1);
	                break;
        default      : WARN("Erroneous format")
	                exit(1);
	               break;
      }
    }
    else {
      WARN("Usage: rsa2fml [-ground|-fof]")
      WARN("Optional parameters: (n is an integer)")
      WARN("-size <n> -product <n> -xfactor <n> -yfactor <n>")
      WARN("-file <name> #Put output in the file name.prod")
      WARN("-fof         #First Order encoding")
      WARN("-ground      #Optimized Ground encoding")
      WARN("-balance     #Product is n-bits and factors are n/2-bits")
      WARN("-order       #factor x < factor y")
      WARN("-prime       #Unsatisfiable if product is prime")
      WARN("-format <n>  # Choose the format of the output")
      WARN("               0 - Human readable format (NOT AVAILABLE YET)")
      WARN("               1 - CNF in list format (NOT AVAILABLE YET)")
      WARN("               2 - TPTP library format (default)")
      WARN("               3 - SMODEL format (implies -ground)")
      WARN(" ")
      WARN("-help        #This printout")
      exit(1);
    }
}


FILE *OpenFile(char *file_name)
{
  FILE *fp;

  fp=fopen(file_name,"w");
  if (fp==NULL) {
    printf("ERROR - cannot open file - ERROR\n");
    printf("%s cannot be created (or rewritten)\n",file_name);
    exit(1);
  }
  return fp;
}




