#include <stdio.h>
#include <stdlib.h>
#include <string.h>

int main(int argc, char *argv[])
{

  FILE *probfp;
  FILE *solfp;

  ScanParameters(argc,argv);

  probfp=OpenFile(ProblemFile);

  if (flag_solX || flag_solY) {
    SolutionFile=(char *)strdup(ProblemFile);
    strcat(SolutionFile,".factors");
    solfp=OpenFile(SolutionFile);
  }

  if (flag_solX && flag_solY) {
    Product=XFactor*YFactor;
  }

  if (flag_balance && Size%2!=0) {
    WARN("When balanced, size must be even\n... rounding down")
    Size=Size-1;
  }
  
  if (flag_balance) {
    WARN("Balanced Encoding M=X*Y")
    balanced_product(probfp,Size/2);
  }
  else {
    WARN("Standard Encoding M=X*Y")
    product(probfp,Size);
  }

  if (flag_order) {
    WARN("Encoding X < Y")
    ordering(probfp,Size/2);
  }
  if (flag_prime) {
    WARN("Encoding Product M is Not Prime")
    primality(probfp,Size);
  }
    
  WARN("Encoding Value Product M")
  value(probfp,"m",Product,Size);

  if (flag_solX) {
    WARN("Encoding Value Factor X")
    value(solfp,"x",XFactor,Size);
  }
  if (flag_solY) {
    WARN("Encoding Value Factor Y")
    value(solfp,"y",YFactor,Size);
  }
  
  if (flag_format==SMODELS) {
    WARN("Encoding Choices for Y and X for NMR")
    choices(probfp,"x",Size);
    choices(probfp,"y",Size);
  } 

  if (flag_solY || flag_solY) 
    fclose(solfp);
  fclose(probfp);

  return(0);
}





